/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.events.characters;

import java.io.IOException;
import org.ballerinalang.stdlib.io.channels.base.Channel;
import org.ballerinalang.stdlib.io.channels.base.CharacterChannel;
import org.ballerinalang.stdlib.io.events.Event;
import org.ballerinalang.stdlib.io.events.EventContext;
import org.ballerinalang.stdlib.io.events.EventResult;
import org.ballerinalang.stdlib.io.events.EventType;
import org.ballerinalang.stdlib.io.events.result.NumericResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteCharactersEvent
implements Event {
    private CharacterChannel channel;
    private String content;
    private int offset;
    private EventContext context;
    private static final Logger log = LoggerFactory.getLogger(WriteCharactersEvent.class);

    public WriteCharactersEvent(CharacterChannel channel, String content, int offset) {
        this.channel = channel;
        this.content = content;
        this.offset = offset;
    }

    public WriteCharactersEvent(CharacterChannel channel, String content, int offset, EventContext context) {
        this.channel = channel;
        this.content = content;
        this.offset = offset;
        this.context = context;
    }

    @Override
    public EventResult get() {
        NumericResult result;
        try {
            int numberOfCharactersWritten = this.channel.write(this.content, this.offset);
            result = new NumericResult(numberOfCharactersWritten, this.context);
        }
        catch (IOException e) {
            log.error("Error occurred while writing characters", (Throwable)e);
            this.context.setError(e);
            result = new NumericResult(this.context);
        }
        catch (Throwable e) {
            log.error("Unidentified error occurred while writing characters", e);
            this.context.setError(e);
            result = new NumericResult(this.context);
        }
        return result;
    }

    @Override
    public int getChannelId() {
        return this.channel.id();
    }

    @Override
    public boolean isSelectable() {
        return this.channel.isSelectable();
    }

    @Override
    public EventType getType() {
        return EventType.WRITE;
    }

    @Override
    public Channel getChannel() {
        return this.channel.getChannel();
    }

    @Override
    public boolean remaining() {
        return this.channel.remaining();
    }
}

