/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.events.records;

import java.io.IOException;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.model.values.BValueArray;
import org.ballerinalang.stdlib.io.channels.base.Channel;
import org.ballerinalang.stdlib.io.channels.base.DelimitedRecordChannel;
import org.ballerinalang.stdlib.io.events.Event;
import org.ballerinalang.stdlib.io.events.EventContext;
import org.ballerinalang.stdlib.io.events.EventResult;
import org.ballerinalang.stdlib.io.events.EventType;
import org.ballerinalang.stdlib.io.events.result.NumericResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelimitedRecordWriteEvent
implements Event {
    private boolean jvmValue = false;
    private DelimitedRecordChannel channel;
    private BValueArray content;
    private ArrayValue arrayValueContent;
    private EventContext context;
    private static final Logger log = LoggerFactory.getLogger(DelimitedRecordWriteEvent.class);

    public DelimitedRecordWriteEvent(DelimitedRecordChannel channel, BValueArray content) {
        this.channel = channel;
        this.content = content;
    }

    public DelimitedRecordWriteEvent(DelimitedRecordChannel channel, BValueArray content, EventContext context) {
        this.channel = channel;
        this.content = content;
        this.context = context;
    }

    public DelimitedRecordWriteEvent(DelimitedRecordChannel channel, ArrayValue content, EventContext context, boolean jvmValue) {
        this.channel = channel;
        this.arrayValueContent = content;
        this.context = context;
        this.jvmValue = jvmValue;
    }

    @Override
    public EventResult get() {
        NumericResult result;
        try {
            if (this.jvmValue) {
                this.channel.write(this.arrayValueContent);
            } else {
                this.channel.write(this.content);
            }
            result = new NumericResult(-1, this.context);
        }
        catch (IOException e) {
            log.error("Error occurred while reading from record channel", (Throwable)e);
            this.context.setError(e);
            result = new NumericResult(this.context);
        }
        catch (Throwable e) {
            log.error("Unidentified error occurred while writing delimited records", e);
            this.context.setError(e);
            result = new NumericResult(this.context);
        }
        return result;
    }

    @Override
    public int getChannelId() {
        return this.channel.id();
    }

    @Override
    public boolean isSelectable() {
        return this.channel.isSelectable();
    }

    @Override
    public EventType getType() {
        return EventType.WRITE;
    }

    @Override
    public Channel getChannel() {
        return this.channel.getChannel();
    }

    @Override
    public boolean remaining() {
        return this.channel.remaining();
    }
}

