/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.events.records;

import java.io.IOException;
import org.ballerinalang.stdlib.io.channels.base.Channel;
import org.ballerinalang.stdlib.io.channels.base.DelimitedRecordChannel;
import org.ballerinalang.stdlib.io.events.Event;
import org.ballerinalang.stdlib.io.events.EventContext;
import org.ballerinalang.stdlib.io.events.EventResult;
import org.ballerinalang.stdlib.io.events.EventType;
import org.ballerinalang.stdlib.io.events.result.BooleanResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HasNextDelimitedRecordEvent
implements Event {
    private DelimitedRecordChannel channel;
    private EventContext context;
    private static final Logger log = LoggerFactory.getLogger(HasNextDelimitedRecordEvent.class);

    public HasNextDelimitedRecordEvent(DelimitedRecordChannel channel, EventContext context) {
        this.channel = channel;
        this.context = context;
    }

    @Override
    public EventResult get() {
        BooleanResult result;
        try {
            if (this.channel.hasReachedEnd()) {
                if (log.isDebugEnabled()) {
                    log.debug("Channel " + this.channel.hashCode() + " reached its end");
                }
                this.context.setError(new Throwable("io.EOF"));
                result = new BooleanResult(false, this.context);
            } else {
                boolean hasNext = this.channel.hasNext();
                result = new BooleanResult(hasNext, this.context);
            }
        }
        catch (IOException e) {
            String message = "Error occurred while reading bytes for hasNext()";
            log.error(message, (Throwable)e);
            this.context.setError(e);
            result = new BooleanResult(this.context);
        }
        catch (Throwable e) {
            log.error("Unidentified error occurred while performing hasNext()", e);
            this.context.setError(e);
            result = new BooleanResult(this.context);
        }
        return result;
    }

    @Override
    public int getChannelId() {
        return this.channel.id();
    }

    @Override
    public boolean isSelectable() {
        return this.channel.isSelectable();
    }

    @Override
    public EventType getType() {
        return EventType.READ;
    }

    @Override
    public Channel getChannel() {
        return this.channel.getChannel();
    }

    @Override
    public boolean remaining() {
        return this.channel.remaining();
    }
}

