/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.nativeimpl;

import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.connector.NonBlockingCallback;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.stdlib.io.channels.base.CharacterChannel;
import org.ballerinalang.stdlib.io.events.EventContext;
import org.ballerinalang.stdlib.io.events.EventRegister;
import org.ballerinalang.stdlib.io.events.EventResult;
import org.ballerinalang.stdlib.io.events.Register;
import org.ballerinalang.stdlib.io.events.characters.CloseCharacterChannelEvent;
import org.ballerinalang.stdlib.io.utils.IOUtils;

@BallerinaFunction(orgName="ballerina", packageName="io", functionName="close", receiver=@Receiver(type=TypeKind.OBJECT, structType="WritableCharacterChannel", structPackage="ballerina/io"), returnType={@ReturnType(type=TypeKind.ERROR)}, isPublic=true)
public class CloseWritableCharacterChannel {
    public static Object close(Strand strand, ObjectValue channel) {
        CharacterChannel charChannel = (CharacterChannel)channel.getNativeData("char_channel");
        EventContext eventContext = new EventContext(new NonBlockingCallback(strand));
        CloseCharacterChannelEvent closeEvent = new CloseCharacterChannelEvent(charChannel, eventContext);
        Register register = EventRegister.getFactory().register(closeEvent, CloseWritableCharacterChannel::closeChannel);
        eventContext.setRegister(register);
        register.submit();
        return null;
    }

    private static EventResult closeChannel(EventResult<Boolean, EventContext> result) {
        EventContext eventContext = result.getContext();
        NonBlockingCallback callback = eventContext.getNonBlockingCallback();
        Throwable error = eventContext.getError();
        if (null != error) {
            callback.setReturnValues((Object)IOUtils.createError(error.getMessage()));
        }
        callback.notifySuccess();
        return result;
    }
}

