/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.nativeimpl;

import java.io.ByteArrayInputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.stdlib.io.channels.AbstractNativeChannel;
import org.ballerinalang.stdlib.io.channels.BlobChannel;
import org.ballerinalang.stdlib.io.channels.BlobIOChannel;
import org.ballerinalang.stdlib.io.channels.base.Channel;
import org.ballerinalang.stdlib.io.utils.IOUtils;

@BallerinaFunction(orgName="ballerina", packageName="io", functionName="createReadableChannel", args={@Argument(name="content", type=TypeKind.ARRAY, elementType=TypeKind.BYTE)}, isPublic=true)
public class CreateMemoryChannel
extends AbstractNativeChannel {
    public static Object createReadableChannel(Strand strand, ArrayValue content) {
        try {
            Channel channel = CreateMemoryChannel.inFlow(content);
            return CreateMemoryChannel.createChannel(channel);
        }
        catch (BallerinaException e) {
            return IOUtils.createError(e.getMessage());
        }
    }

    private static Channel inFlow(ArrayValue contentArr) {
        try {
            byte[] content = CreateMemoryChannel.shrink(contentArr);
            ByteArrayInputStream contentStream = new ByteArrayInputStream(content);
            ReadableByteChannel readableByteChannel = Channels.newChannel(contentStream);
            return new BlobIOChannel(new BlobChannel(readableByteChannel));
        }
        catch (Throwable e) {
            String message = "Error occurred while obtaining channel";
            throw new BallerinaException(message, e);
        }
    }

    private static byte[] shrink(ArrayValue array) {
        int contentLength = array.size();
        byte[] content = new byte[contentLength];
        System.arraycopy(array.getBytes(), 0, content, 0, contentLength);
        return content;
    }
}

