/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.nativeimpl;

import java.nio.ByteOrder;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.stdlib.io.channels.base.Channel;
import org.ballerinalang.stdlib.io.channels.base.DataChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(orgName="ballerina", packageName="io", functionName="init", receiver=@Receiver(type=TypeKind.OBJECT, structType="ReadableDataChannel", structPackage="ballerina/io"), args={@Argument(name="byteChannel", type=TypeKind.OBJECT, structType="ReadableByteChannel", structPackage="ballerina/io"), @Argument(name="order", type=TypeKind.STRING)}, isPublic=true)
public class CreateReadableDataChannel {
    private static final Logger log = LoggerFactory.getLogger(CreateReadableDataChannel.class);

    private static ByteOrder getByteOrder(String byteOrder) {
        switch (byteOrder) {
            case "BE": {
                return ByteOrder.BIG_ENDIAN;
            }
            case "LE": {
                return ByteOrder.LITTLE_ENDIAN;
            }
        }
        return ByteOrder.nativeOrder();
    }

    public static void init(Strand strand, ObjectValue dataChannelObj, ObjectValue byteChannelObj, Object order) {
        try {
            ByteOrder byteOrder = CreateReadableDataChannel.getByteOrder((String)order);
            Channel channel = (Channel)byteChannelObj.getNativeData("byteChannel");
            DataChannel dataChannel = new DataChannel(channel, byteOrder);
            dataChannelObj.addNativeData("data_channel", (Object)dataChannel);
        }
        catch (Exception e) {
            String message = "Error while creating data channel:" + e.getMessage();
            log.error(message, (Throwable)e);
            throw new BallerinaException(message, (Throwable)e);
        }
    }
}

