/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.nativeimpl;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BField;
import org.ballerinalang.jvm.types.BStructureType;
import org.ballerinalang.jvm.types.BTableType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BUnionType;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.jvm.values.MapValueImpl;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.TableValue;
import org.ballerinalang.jvm.values.TypedescValue;
import org.ballerinalang.jvm.values.connector.NonBlockingCallback;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.stdlib.io.channels.base.DelimitedRecordChannel;
import org.ballerinalang.stdlib.io.events.EventContext;
import org.ballerinalang.stdlib.io.events.EventRegister;
import org.ballerinalang.stdlib.io.events.EventResult;
import org.ballerinalang.stdlib.io.events.Register;
import org.ballerinalang.stdlib.io.events.records.DelimitedRecordReadAllEvent;
import org.ballerinalang.stdlib.io.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(orgName="ballerina", packageName="io", functionName="getTable", receiver=@Receiver(type=TypeKind.OBJECT, structType="ReadableCSVChannel", structPackage="ballerina/io"), args={@Argument(name="structType", type=TypeKind.TYPEDESC)}, returnType={@ReturnType(type=TypeKind.TABLE), @ReturnType(type=TypeKind.ERROR)}, isPublic=true)
public class GetTable {
    private static final Logger log = LoggerFactory.getLogger(GetTable.class);
    private static final String CSV_CHANNEL_DELIMITED_STRUCT_FIELD = "dc";
    private static final String TYPE_DESC_VALUE = "TypedescValue";

    public static Object getTable(Strand strand, ObjectValue csvChannel, TypedescValue typedescValue) {
        NonBlockingCallback callback = new NonBlockingCallback(strand);
        try {
            ObjectValue delimitedObj = (ObjectValue)csvChannel.get(CSV_CHANNEL_DELIMITED_STRUCT_FIELD);
            DelimitedRecordChannel delimitedChannel = (DelimitedRecordChannel)delimitedObj.getNativeData("txt_record");
            EventContext eventContext = new EventContext(callback);
            eventContext.getProperties().put(TYPE_DESC_VALUE, typedescValue);
            DelimitedRecordReadAllEvent event = new DelimitedRecordReadAllEvent(delimitedChannel, eventContext);
            Register register = EventRegister.getFactory().register(event, GetTable::getResponse);
            eventContext.setRegister(register);
            register.submit();
        }
        catch (Exception e) {
            String msg = "Failed to process the delimited file: " + e.getMessage();
            log.error(msg, (Throwable)e);
            callback.setReturnValues((Object)IOUtils.createError(msg));
            callback.notifySuccess();
        }
        return null;
    }

    private static EventResult getResponse(EventResult<List, EventContext> result) {
        EventContext eventContext = result.getContext();
        NonBlockingCallback callback = eventContext.getNonBlockingCallback();
        Throwable error = eventContext.getError();
        if (null != error) {
            callback.setReturnValues((Object)IOUtils.createError(error.getMessage()));
        } else {
            try {
                List records = result.getResponse();
                TableValue table = GetTable.getTable(eventContext, records);
                callback.setReturnValues((Object)table);
            }
            catch (Throwable e) {
                callback.setReturnValues((Object)IOUtils.createError(e.getMessage()));
            }
        }
        IOUtils.validateChannelState(eventContext);
        callback.notifySuccess();
        return result;
    }

    private static TableValue getTable(EventContext eventContext, List records) throws BallerinaException {
        TypedescValue type = (TypedescValue)eventContext.getProperties().get(TYPE_DESC_VALUE);
        BType describingType = type.getDescribingType();
        TableValue table = new TableValue((BType)new BTableType(describingType), null, null, null);
        BStructureType structType = (BStructureType)describingType;
        for (Object obj : records) {
            String[] fields = (String[])obj;
            MapValueImpl<String, Object> struct = GetTable.getStruct(fields, structType);
            if (struct == null) continue;
            table.addData(struct);
        }
        return table;
    }

    private static MapValueImpl<String, Object> getStruct(String[] fields, BStructureType structType) {
        Map internalStructFields = structType.getFields();
        int fieldLength = internalStructFields.size();
        MapValueImpl struct = null;
        if (fields.length > 0) {
            Iterator itr = internalStructFields.entrySet().iterator();
            struct = new MapValueImpl((BType)structType);
            for (int i = 0; i < fieldLength; ++i) {
                BField internalStructField = (BField)itr.next().getValue();
                int type = internalStructField.getFieldType().getTag();
                String fieldName = internalStructField.getFieldName();
                if (fields.length > i) {
                    String value = fields[i];
                    switch (type) {
                        case 1: 
                        case 3: 
                        case 5: 
                        case 6: {
                            GetTable.populateRecord(type, (MapValueImpl<String, Object>)struct, fieldName, value);
                            break;
                        }
                        case 21: {
                            List members = ((BUnionType)internalStructField.getFieldType()).getMemberTypes();
                            if (((BType)members.get(0)).getTag() == 10) {
                                GetTable.populateRecord(((BType)members.get(1)).getTag(), (MapValueImpl<String, Object>)struct, fieldName, value);
                                break;
                            }
                            if (((BType)members.get(1)).getTag() == 10) {
                                GetTable.populateRecord(((BType)members.get(0)).getTag(), (MapValueImpl<String, Object>)struct, fieldName, value);
                                break;
                            }
                            throw new BallerinaException("fix");
                        }
                        default: {
                            throw new BallerinaException("Type casting support only for int, float, boolean and string. Invalid value for the struct field: " + value);
                        }
                    }
                    continue;
                }
                struct.put((Object)fieldName, null);
            }
        }
        return struct;
    }

    private static void populateRecord(int type, MapValueImpl<String, Object> struct, String fieldName, String value) {
        switch (type) {
            case 1: {
                struct.put((Object)fieldName, value == null ? null : Long.valueOf(Long.parseLong(value)));
                return;
            }
            case 3: {
                struct.put((Object)fieldName, value == null ? null : Double.valueOf(Double.parseDouble(value)));
                break;
            }
            case 5: {
                struct.put((Object)fieldName, (Object)value);
                break;
            }
            case 6: {
                struct.put((Object)fieldName, value == null ? null : Boolean.valueOf(Boolean.parseBoolean(value)));
                break;
            }
            default: {
                throw new BallerinaException("Type casting support only for int, float, boolean and string. Invalid value for the struct field: " + value);
            }
        }
    }
}

