/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.nativeimpl;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.stdlib.io.channels.AbstractNativeChannel;
import org.ballerinalang.stdlib.io.channels.FileIOChannel;
import org.ballerinalang.stdlib.io.channels.base.Channel;
import org.ballerinalang.stdlib.io.utils.IOUtils;

@BallerinaFunction(orgName="ballerina", packageName="io", functionName="openReadableFile", args={@Argument(name="path", type=TypeKind.STRING)}, isPublic=true)
public class OpenReadableFile
extends AbstractNativeChannel {
    private static final String READ_ACCESS_MODE = "r";

    public static Object openReadableFile(Strand strand, String pathUrl) {
        ObjectValue channel;
        try {
            channel = OpenReadableFile.createChannel(OpenReadableFile.inFlow(pathUrl));
        }
        catch (AccessDeniedException e) {
            channel = IOUtils.createError("Do not have access to read file: " + e.getMessage());
        }
        catch (Throwable e) {
            channel = IOUtils.createError("Failed to open file: " + e.getMessage());
        }
        return channel;
    }

    private static Channel inFlow(String pathUrl) throws IOException {
        Path path = Paths.get(pathUrl, new String[0]);
        FileChannel fileChannel = IOUtils.openFileChannelExtended(path, READ_ACCESS_MODE);
        FileIOChannel channel = new FileIOChannel(fileChannel);
        channel.setReadable(true);
        return channel;
    }
}

