/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.nativeimpl;

import java.util.Arrays;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BTupleType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.connector.NonBlockingCallback;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.stdlib.io.channels.base.Channel;
import org.ballerinalang.stdlib.io.events.EventContext;
import org.ballerinalang.stdlib.io.events.EventRegister;
import org.ballerinalang.stdlib.io.events.EventResult;
import org.ballerinalang.stdlib.io.events.Register;
import org.ballerinalang.stdlib.io.events.bytes.ReadBytesEvent;
import org.ballerinalang.stdlib.io.utils.IOUtils;

@BallerinaFunction(orgName="ballerina", packageName="io", functionName="read", receiver=@Receiver(type=TypeKind.OBJECT, structType="ReadableByteChannel", structPackage="ballerina/io"), args={@Argument(name="nBytes", type=TypeKind.INT)}, returnType={@ReturnType(type=TypeKind.ARRAY, elementType=TypeKind.BYTE), @ReturnType(type=TypeKind.INT), @ReturnType(type=TypeKind.ERROR)}, isPublic=true)
public class ReadBytes {
    private static final BTupleType readTupleType = new BTupleType(Arrays.asList(new BArrayType(BTypes.typeByte), BTypes.typeInt));

    public static Object read(Strand strand, ObjectValue channel, long nBytes) {
        int arraySize = nBytes <= 0L ? 16384 : (int)nBytes;
        Channel byteChannel = (Channel)channel.getNativeData("byteChannel");
        byte[] content = new byte[arraySize];
        EventContext eventContext = new EventContext(new NonBlockingCallback(strand));
        ReadBytesEvent event = new ReadBytesEvent(byteChannel, content, eventContext);
        Register register = EventRegister.getFactory().register(event, ReadBytes::readChannelResponse);
        eventContext.setRegister(register);
        register.submit();
        return null;
    }

    private static EventResult readChannelResponse(EventResult<Integer, EventContext> result) {
        ArrayValue contentTuple = new ArrayValue((BType)readTupleType);
        EventContext eventContext = result.getContext();
        Throwable error = eventContext.getError();
        NonBlockingCallback callback = eventContext.getNonBlockingCallback();
        byte[] content = (byte[])eventContext.getProperties().get("byte_content");
        if (null != error) {
            callback.setReturnValues((Object)IOUtils.createError(error.getMessage()));
        } else {
            Integer numberOfBytes = result.getResponse();
            contentTuple.add(0L, (Object)new ArrayValue(content));
            contentTuple.add(1L, (Object)numberOfBytes);
            callback.setReturnValues((Object)contentTuple);
        }
        IOUtils.validateChannelState(eventContext);
        callback.notifySuccess();
        return result;
    }
}

