/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.nativeimpl;

import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.connector.NonBlockingCallback;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.stdlib.io.channels.base.CharacterChannel;
import org.ballerinalang.stdlib.io.events.EventContext;
import org.ballerinalang.stdlib.io.events.EventRegister;
import org.ballerinalang.stdlib.io.events.EventResult;
import org.ballerinalang.stdlib.io.events.Register;
import org.ballerinalang.stdlib.io.events.characters.WriteCharactersEvent;
import org.ballerinalang.stdlib.io.utils.IOUtils;

@BallerinaFunction(orgName="ballerina", packageName="io", functionName="write", receiver=@Receiver(type=TypeKind.OBJECT, structType="WritableCharacterChannel", structPackage="ballerina/io"), args={@Argument(name="content", type=TypeKind.STRING), @Argument(name="startOffset", type=TypeKind.INT)}, returnType={@ReturnType(type=TypeKind.INT), @ReturnType(type=TypeKind.ERROR)}, isPublic=true)
public class WriteCharacters {
    public static Object write(Strand strand, ObjectValue channel, String content, long startOffset) {
        CharacterChannel characterChannel = (CharacterChannel)channel.getNativeData("char_channel");
        EventContext eventContext = new EventContext(new NonBlockingCallback(strand));
        WriteCharactersEvent event = new WriteCharactersEvent(characterChannel, content, (int)startOffset, eventContext);
        Register register = EventRegister.getFactory().register(event, WriteCharacters::writeCharResponse);
        eventContext.setRegister(register);
        register.submit();
        return null;
    }

    private static EventResult writeCharResponse(EventResult<Integer, EventContext> result) {
        EventContext eventContext = result.getContext();
        NonBlockingCallback callback = eventContext.getNonBlockingCallback();
        Throwable error = eventContext.getError();
        if (null != error) {
            callback.setReturnValues((Object)IOUtils.createError(error.getMessage()));
        } else {
            callback.setReturnValues((Object)result.getResponse());
        }
        callback.notifySuccess();
        return result;
    }
}

