/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.readers;

import java.io.IOException;
import java.io.Reader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.ballerinalang.stdlib.io.channels.base.CharacterChannel;
import org.ballerinalang.stdlib.io.events.EventContext;
import org.ballerinalang.stdlib.io.events.EventManager;
import org.ballerinalang.stdlib.io.events.EventResult;
import org.ballerinalang.stdlib.io.events.characters.ReadCharactersEvent;
import org.ballerinalang.stdlib.io.events.result.AlphaResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CharacterChannelReader
extends Reader {
    private static final Logger log = LoggerFactory.getLogger(CharacterChannelReader.class);
    private CharacterChannel channel;
    private EventContext context;

    public CharacterChannelReader(CharacterChannel channel, EventContext context) {
        this.channel = channel;
        this.context = context;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        AlphaResult eventResult;
        if (log.isDebugEnabled()) {
            log.debug("Read offset: " + off + " length: " + len);
        }
        ReadCharactersEvent event = new ReadCharactersEvent(this.channel, len, this.context);
        CompletableFuture<EventResult> future = EventManager.getInstance().publish(event);
        try {
            eventResult = (AlphaResult)future.get();
            Throwable error = eventResult.getContext().getError();
            if (null != error && !"io.EOF".equals(error.getMessage())) {
                throw new IOException(error);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException(e);
        }
        String response = eventResult.getResponse();
        if (response != null && !response.isEmpty()) {
            char[] chars = response.toCharArray();
            System.arraycopy(chars, 0, cbuf, off, chars.length);
            if (log.isDebugEnabled()) {
                log.debug("No of characters read: " + chars.length);
            }
            return chars.length;
        }
        return -1;
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }
}

