/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.time.zone.ZoneRulesException;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BLangVMStructs;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.stdlib.io.channels.base.Channel;
import org.ballerinalang.stdlib.io.utils.Base64ByteChannel;
import org.ballerinalang.stdlib.io.utils.Base64Wrapper;
import org.ballerinalang.stdlib.io.utils.IOConstants;
import org.ballerinalang.util.codegen.PackageInfo;
import org.ballerinalang.util.codegen.StructureTypeInfo;

public class Utils {
    public static final String PACKAGE_TIME = "ballerina/time";
    public static final String STRUCT_TYPE_TIME = "Time";
    public static final String STRUCT_TYPE_TIMEZONE = "Timezone";
    public static final int READABLE_BUFFER_SIZE = 8192;
    public static final String PROTOCOL_PACKAGE_MIME = "ballerina/mime";
    public static final String MIME_ERROR_MESSAGE = "message";
    public static final String ERROR_RECORD_TYPE = "Detail";
    private static final String STRUCT_TYPE = "ReadableByteChannel";
    private static final String ENCODING_ERROR = "{ballerina/mime}EncodingFailed";
    private static final String DECODING_ERROR = "{ballerina/mime}DecodingFailed";

    public static BMap<String, BValue> createTimeZone(StructureTypeInfo timezoneStructInfo, String zoneIdValue) {
        try {
            ZoneId zoneId = ZoneId.of(zoneIdValue);
            String zoneIdName = zoneId.toString();
            TimeZone tz = TimeZone.getTimeZone(zoneId);
            int offsetInMills = tz.getOffset(new Date().getTime());
            int offset = offsetInMills / 1000;
            return BLangVMStructs.createBStruct((StructureTypeInfo)timezoneStructInfo, (Object[])new Object[]{zoneIdName, offset});
        }
        catch (ZoneRulesException e) {
            throw new BallerinaException("invalid timezone id: " + zoneIdValue);
        }
    }

    public static MapValue<String, BValue> createTimeZone(MapValue timezoneStructInfo, String zoneIdValue) {
        try {
            ZoneId zoneId = ZoneId.of(zoneIdValue);
            String zoneIdName = zoneId.toString();
            TimeZone tz = TimeZone.getTimeZone(zoneId);
            int offsetInMills = tz.getOffset(new Date().getTime());
            int offset = offsetInMills / 1000;
            return BallerinaValues.createRecord((MapValue)timezoneStructInfo, (Object[])new Object[]{zoneIdName, offset});
        }
        catch (ZoneRulesException e) {
            throw new BallerinaException("invalid timezone id: " + zoneIdValue);
        }
    }

    public static BMap<String, BValue> createTimeStruct(StructureTypeInfo timezoneStructInfo, StructureTypeInfo timeStructInfo, long millis, String zoneIdName) {
        BMap<String, BValue> timezone = Utils.createTimeZone(timezoneStructInfo, zoneIdName);
        return BLangVMStructs.createBStruct((StructureTypeInfo)timeStructInfo, (Object[])new Object[]{millis, timezone});
    }

    public static MapValue<String, BValue> createTimeStruct(MapValue timezoneStructInfo, MapValue timeStructInfo, long millis, String zoneIdName) {
        MapValue<String, BValue> timezone = Utils.createTimeZone(timezoneStructInfo, zoneIdName);
        return BallerinaValues.createRecord((MapValue)timeStructInfo, (Object[])new Object[]{millis, timezone});
    }

    public static StructureTypeInfo getTimeZoneStructInfo(Context context) {
        PackageInfo timePackageInfo = context.getProgramFile().getPackageInfo(PACKAGE_TIME);
        if (timePackageInfo == null) {
            return null;
        }
        return timePackageInfo.getStructInfo(STRUCT_TYPE_TIMEZONE);
    }

    public static MapValue<String, Object> getTimeZoneStructInfo() {
        return BallerinaValues.createRecordValue((String)PACKAGE_TIME, (String)STRUCT_TYPE_TIMEZONE);
    }

    public static StructureTypeInfo getTimeStructInfo(Context context) {
        PackageInfo timePackageInfo = context.getProgramFile().getPackageInfo(PACKAGE_TIME);
        if (timePackageInfo == null) {
            return null;
        }
        return timePackageInfo.getStructInfo(STRUCT_TYPE_TIME);
    }

    public static MapValue<String, Object> getTimeStructInfo() {
        return BallerinaValues.createRecordValue((String)PACKAGE_TIME, (String)STRUCT_TYPE_TIME);
    }

    private static ErrorValue createBase64Error(String reason, String msg, boolean isMimeSpecific) {
        if (isMimeSpecific) {
            return BallerinaErrors.createError((String)reason, (MapValue)Utils.populateMimeErrorRecord(msg));
        }
        return BallerinaErrors.createError((String)IOConstants.ErrorCode.GenericError.errorCode(), (String)msg);
    }

    public static MapValue populateMimeErrorRecord(String msg) {
        HashMap<String, String> valueMap = new HashMap<String, String>();
        valueMap.put(MIME_ERROR_MESSAGE, msg);
        return BallerinaValues.createRecordValue((String)PROTOCOL_PACKAGE_MIME, (String)ERROR_RECORD_TYPE, valueMap);
    }

    private static byte[] getByteArray(InputStream input) throws IOException {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            int len;
            byte[] buffer = new byte[8192];
            while ((len = input.read(buffer)) != -1) {
                output.write(buffer, 0, len);
            }
            byte[] byArray = output.toByteArray();
            return byArray;
        }
    }

    public static Object encode(Object input, String charset, boolean isMimeSpecific) {
        switch (TypeChecker.getType((Object)input).getTag()) {
            case 20: {
                return Utils.encodeBlob(((ArrayValue)input).getBytes(), isMimeSpecific);
            }
            case 12: 
            case 35: {
                ObjectValue byteChannel = (ObjectValue)input;
                if (STRUCT_TYPE.equals(byteChannel.getType().getName())) {
                    return Utils.encodeByteChannel(byteChannel, isMimeSpecific);
                }
                return Utils.createBase64Error(ENCODING_ERROR, "incompatible object", isMimeSpecific);
            }
            case 5: {
                return Utils.encodeString(input.toString(), charset, isMimeSpecific);
            }
        }
        return Utils.createBase64Error(ENCODING_ERROR, "incompatible input", isMimeSpecific);
    }

    public static Object decode(Object encodedInput, String charset, boolean isMimeSpecific) {
        switch (TypeChecker.getType((Object)encodedInput).getTag()) {
            case 20: {
                return Utils.decodeBlob(((ArrayValue)encodedInput).getBytes(), isMimeSpecific);
            }
            case 12: 
            case 35: {
                return Utils.decodeByteChannel((ObjectValue)encodedInput, isMimeSpecific);
            }
            case 5: {
                return Utils.decodeString(encodedInput, charset, isMimeSpecific);
            }
        }
        return Utils.createBase64Error(DECODING_ERROR, "incompatible input", isMimeSpecific);
    }

    public static Object encodeString(String stringToBeEncoded, String charset, boolean isMimeSpecific) {
        try {
            byte[] encodedValue = isMimeSpecific ? Base64.getMimeEncoder().encode(stringToBeEncoded.getBytes(charset)) : Base64.getEncoder().encode(stringToBeEncoded.getBytes(charset));
            return new String(encodedValue, StandardCharsets.ISO_8859_1);
        }
        catch (UnsupportedEncodingException e) {
            return Utils.createBase64Error(DECODING_ERROR, e.getMessage(), isMimeSpecific);
        }
    }

    private static Object decodeString(Object stringToBeDecoded, String charset, boolean isMimeSpecific) {
        try {
            byte[] decodedValue = isMimeSpecific ? Base64.getMimeDecoder().decode(stringToBeDecoded.toString().getBytes(StandardCharsets.ISO_8859_1)) : Base64.getDecoder().decode(stringToBeDecoded.toString().getBytes(StandardCharsets.ISO_8859_1));
            return new String(decodedValue, charset);
        }
        catch (UnsupportedEncodingException e) {
            return Utils.createBase64Error(DECODING_ERROR, e.getMessage(), isMimeSpecific);
        }
    }

    public static Object encodeByteChannel(ObjectValue byteChannel, boolean isMimeSpecific) {
        Channel channel = (Channel)byteChannel.getNativeData("byteChannel");
        try {
            byte[] encodedByteArray = isMimeSpecific ? Base64.getMimeEncoder().encode(Utils.getByteArray(channel.getInputStream())) : Base64.getEncoder().encode(Utils.getByteArray(channel.getInputStream()));
            ByteArrayInputStream encodedStream = new ByteArrayInputStream(encodedByteArray);
            Base64ByteChannel decodedByteChannel = new Base64ByteChannel(encodedStream);
            ObjectValue byteChannelObj = BallerinaValues.createObjectValue((String)"ballerina/io", (String)STRUCT_TYPE, (Object[])new Object[0]);
            byteChannelObj.addNativeData("byteChannel", (Object)new Base64Wrapper(decodedByteChannel));
            return byteChannelObj;
        }
        catch (IOException e) {
            return Utils.createBase64Error(ENCODING_ERROR, e.getMessage(), isMimeSpecific);
        }
    }

    public static Object decodeByteChannel(ObjectValue byteChannel, boolean isMimeSpecific) {
        Channel channel = (Channel)byteChannel.getNativeData("byteChannel");
        try {
            byte[] decodedByteArray = isMimeSpecific ? Base64.getMimeDecoder().decode(Utils.getByteArray(channel.getInputStream())) : Base64.getDecoder().decode(Utils.getByteArray(channel.getInputStream()));
            ByteArrayInputStream decodedStream = new ByteArrayInputStream(decodedByteArray);
            Base64ByteChannel decodedByteChannel = new Base64ByteChannel(decodedStream);
            ObjectValue byteChannelObj = BallerinaValues.createObjectValue((String)"ballerina/io", (String)STRUCT_TYPE, (Object[])new Object[0]);
            byteChannelObj.addNativeData("byteChannel", (Object)new Base64Wrapper(decodedByteChannel));
            return byteChannelObj;
        }
        catch (IOException e) {
            return Utils.createBase64Error(DECODING_ERROR, e.getMessage(), isMimeSpecific);
        }
    }

    public static ArrayValue encodeBlob(byte[] bytes, boolean isMimeSpecific) {
        byte[] encodedContent = isMimeSpecific ? Base64.getMimeEncoder().encode(bytes) : Base64.getEncoder().encode(bytes);
        return new ArrayValue(encodedContent);
    }

    public static ArrayValue decodeBlob(byte[] encodedContent, boolean isMimeSpecific) {
        byte[] decodedContent = isMimeSpecific ? Base64.getMimeDecoder().decode(encodedContent) : Base64.getDecoder().decode(encodedContent);
        return new ArrayValue(decodedContent);
    }
}

