/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.channels;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import org.ballerinalang.stdlib.io.channels.base.Channel;
import org.ballerinalang.stdlib.io.channels.base.readers.ChannelReader;
import org.ballerinalang.stdlib.io.channels.base.writers.ChannelWriter;
import org.ballerinalang.stdlib.io.utils.BallerinaIOException;

public class FileIOChannel
extends Channel {
    private FileChannel channel;

    public FileIOChannel(FileChannel channel) throws BallerinaIOException {
        super(channel, new ChannelReader(), new ChannelWriter());
        this.channel = channel;
    }

    @Override
    public void transfer(int position, int count, WritableByteChannel dstChannel) throws IOException {
        try {
            this.channel.transferTo(position, count, dstChannel);
        }
        catch (IOException e) {
            throw new BallerinaIOException("Error occurred while transferring file", e);
        }
    }

    @Override
    public Channel getChannel() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSelectable() {
        return false;
    }

    @Override
    public boolean remaining() {
        return false;
    }
}

