/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.channels.base;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.ballerinalang.stdlib.io.channels.base.Channel;
import org.ballerinalang.stdlib.io.channels.base.CharacterChannel;
import org.ballerinalang.stdlib.io.channels.base.IOChannel;
import org.ballerinalang.stdlib.io.channels.base.Representation;
import org.ballerinalang.stdlib.io.channels.base.data.LongResult;

public class DataChannel
implements IOChannel {
    private Channel channel;
    private ByteOrder order;
    private static final long BIT_64_LONG_MAX = -1L;

    public DataChannel(Channel channel, ByteOrder order) {
        this.channel = channel;
        this.order = order;
    }

    @Override
    public boolean hasReachedEnd() {
        return this.channel.hasReachedEnd();
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }

    private byte[] reverse(ByteBuffer buffer) {
        byte[] contentArr = buffer.array();
        int length = buffer.limit();
        byte[] reverseContent = new byte[length];
        for (int count = 0; count < length; ++count) {
            reverseContent[count] = contentArr[length - 1 - count];
        }
        return reverseContent;
    }

    private void readFull(ByteBuffer buffer, Representation representation) throws IOException {
        do {
            this.channel.read(buffer);
        } while (buffer.hasRemaining() && !this.channel.hasReachedEnd());
        if (this.order.equals(ByteOrder.LITTLE_ENDIAN) && !representation.equals((Object)Representation.VARIABLE)) {
            int bufferPosition = buffer.position();
            int limit = buffer.limit();
            byte[] reverseContent = this.reverse(buffer);
            buffer.rewind();
            buffer.put(reverseContent, 0, limit);
            buffer.position(bufferPosition);
            buffer.limit(limit);
        }
    }

    private ByteBuffer readVarInt() throws IOException {
        int bufferLimit = 0;
        boolean hasRemainingBytes = true;
        byte[] content = new byte[8];
        ByteBuffer buf = ByteBuffer.wrap(content);
        do {
            buf.limit(++bufferLimit);
            this.readFull(buf, Representation.VARIABLE);
            buf.flip();
            byte b = buf.get(bufferLimit - 1);
            if ((b & 0x80) >> 7 == 0) {
                hasRemainingBytes = false;
            }
            buf.put(bufferLimit - 1, (byte)(b & 0x7F));
            buf.position(buf.limit());
        } while (hasRemainingBytes);
        return buf;
    }

    private LongResult decodeLong(Representation representation) throws IOException {
        ByteBuffer buffer;
        if (Representation.VARIABLE.equals((Object)representation)) {
            buffer = this.readVarInt();
            if (this.order.equals(ByteOrder.LITTLE_ENDIAN)) {
                byte[] reverse = this.reverse(buffer);
                buffer.rewind();
                buffer.put(reverse);
            }
        } else {
            int requiredNumberOfBytes = representation.getNumberOfBytes();
            buffer = ByteBuffer.allocate(requiredNumberOfBytes);
            buffer.order(this.order);
            this.readFull(buffer, representation);
        }
        buffer.flip();
        return this.deriveLong(representation, buffer);
    }

    private long convertVarLongToFixedLong(long value, int nBytes) {
        int nBits = nBytes * Representation.VARIABLE.getBase() - 1;
        if (value >> nBits == 1L) {
            long intercept = -1L << nBits;
            value |= intercept;
        }
        return value;
    }

    private LongResult deriveLong(Representation representation, ByteBuffer buffer) {
        long value = 0L;
        int maxNumberOfBits = 65535;
        int byteLimit = buffer.limit();
        int totalNumberOfBits = (byteLimit - 1) * representation.getBase();
        do {
            long flippedValue;
            long shiftedValue = 0L;
            if (Representation.BIT_64.equals((Object)representation)) {
                flippedValue = buffer.get() & maxNumberOfBits;
                shiftedValue = flippedValue << totalNumberOfBits;
            } else if (Representation.BIT_32.equals((Object)representation)) {
                int flippedValue2 = buffer.get() & maxNumberOfBits;
                shiftedValue = flippedValue2 << totalNumberOfBits;
            } else if (Representation.BIT_16.equals((Object)representation)) {
                short flippedValue3 = (short)(buffer.get() & maxNumberOfBits);
                shiftedValue = flippedValue3 << totalNumberOfBits;
            } else if (Representation.VARIABLE.equals((Object)representation)) {
                flippedValue = buffer.get() & maxNumberOfBits;
                shiftedValue = flippedValue << totalNumberOfBits;
            }
            maxNumberOfBits = 255;
            value += shiftedValue;
            totalNumberOfBits -= representation.getBase();
        } while (buffer.hasRemaining());
        if (Representation.VARIABLE.equals((Object)representation)) {
            value = this.convertVarLongToFixedLong(value, byteLimit);
        }
        return new LongResult(value, byteLimit);
    }

    private byte[] reverseOrder(byte[] content) {
        byte[] reversedContent = new byte[content.length];
        int length = content.length;
        for (int count = 0; count < length; ++count) {
            reversedContent[count] = (byte)(content[length - 1 - count] & 0x7F);
            if (count >= length - 1) continue;
            reversedContent[count] = (byte)(content[length - 1 - count] | 0x80);
        }
        return reversedContent;
    }

    private byte[] encodeLong(long value, Representation representation) {
        byte[] content;
        int nBytes;
        if (Representation.VARIABLE.equals((Object)representation)) {
            int nBits = (int)Math.abs(Math.round(Math.log(Math.abs(value)) / Math.log(2.0)));
            nBytes = nBits / representation.getBase() + 1;
            content = new byte[nBytes];
        } else {
            nBytes = representation.getNumberOfBytes();
            content = new byte[representation.getNumberOfBytes()];
        }
        int totalNumberOfBits = nBytes * representation.getBase() - representation.getBase();
        for (int count = 0; count < nBytes; ++count) {
            content[count] = (byte)(value >> totalNumberOfBits);
            if (Representation.VARIABLE.equals((Object)representation) && this.order.equals(ByteOrder.BIG_ENDIAN)) {
                content[count] = (byte)(content[count] & 0x7F);
                if (count < nBytes - 1) {
                    content[count] = (byte)(content[count] | 0x80);
                }
            }
            totalNumberOfBits -= representation.getBase();
        }
        return content;
    }

    private void write(ByteBuffer buffer, Representation representation) throws IOException {
        if (this.order.equals(ByteOrder.LITTLE_ENDIAN) && !Representation.VARIABLE.equals((Object)representation)) {
            byte[] reverse = this.reverse(buffer);
            this.channel.write(ByteBuffer.wrap(reverse));
        } else if (this.order.equals(ByteOrder.LITTLE_ENDIAN) && Representation.VARIABLE.equals((Object)representation)) {
            byte[] reverse = this.reverseOrder(buffer.array());
            this.channel.write(ByteBuffer.wrap(reverse));
        } else {
            this.channel.write(buffer);
        }
    }

    public void writeLong(long value, Representation representation) throws IOException {
        byte[] bytes = this.encodeLong(value, representation);
        this.write(ByteBuffer.wrap(bytes), representation);
    }

    public LongResult readLong(Representation representation) throws IOException {
        return this.decodeLong(representation);
    }

    public void writeDouble(double value, Representation representation) throws IOException {
        long lValue = Representation.BIT_32.equals((Object)representation) ? (long)Float.floatToIntBits((float)value) : Double.doubleToRawLongBits(value);
        this.writeLong(lValue, representation);
    }

    public double readDouble(Representation representation) throws IOException {
        if (Representation.BIT_32.equals((Object)representation)) {
            int fValue = (int)this.readLong(Representation.BIT_32).getValue();
            return Float.intBitsToFloat(fValue);
        }
        long lValue = this.readLong(representation).getValue();
        return Double.longBitsToDouble(lValue);
    }

    public void writeBoolean(boolean value) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(1);
        byte booleanValue = (byte)(value ? 1 : 0);
        buffer.put(booleanValue);
        buffer.flip();
        this.write(buffer, Representation.NONE);
    }

    public boolean readBoolean() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(1);
        this.readFull(buffer, Representation.NONE);
        buffer.flip();
        return buffer.get() == 1;
    }

    public void writeString(String content, String encoding) throws IOException {
        CharacterChannel ch = new CharacterChannel(this.channel, encoding);
        ch.write(content, 0);
    }

    public String readString(int nBytes, String encoding) throws IOException {
        CharacterChannel ch = new CharacterChannel(this.channel, encoding);
        return ch.readAllChars(nBytes);
    }

    @Override
    public boolean isSelectable() {
        return this.channel.isSelectable();
    }

    @Override
    public int id() {
        return this.channel.id();
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    @Override
    public boolean remaining() {
        return false;
    }
}

