/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.channels.base.readers;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.NonReadableChannelException;
import org.ballerinalang.stdlib.io.channels.base.readers.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelReader
implements Reader {
    private static final Logger log = LoggerFactory.getLogger(ChannelReader.class);

    @Override
    public int read(ByteBuffer content, ByteChannel channel) throws IOException {
        try {
            return channel.read(content);
        }
        catch (IOException | NonReadableChannelException e) {
            String message = "could not read from the channel";
            log.error(message, (Throwable)e);
            throw new IOException(message, e);
        }
    }
}

