/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.channels.base.writers;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.NonWritableChannelException;
import org.ballerinalang.stdlib.io.channels.base.writers.Writer;
import org.ballerinalang.stdlib.io.utils.BallerinaIOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelWriter
implements Writer {
    private static final Logger log = LoggerFactory.getLogger(ChannelWriter.class);

    @Override
    public int write(ByteBuffer content, ByteChannel channel) throws BallerinaIOException {
        int numberOfBytesWritten;
        try {
            numberOfBytesWritten = channel.write(content);
            if (log.isTraceEnabled()) {
                log.trace("Number of bytes " + numberOfBytesWritten + " written to channel " + channel.hashCode());
            }
        }
        catch (IOException | NonWritableChannelException e) {
            String message = "Error occurred while writing to channel ";
            throw new BallerinaIOException(message, e);
        }
        return numberOfBytesWritten;
    }
}

