/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.events;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.ballerinalang.jvm.runtime.BLangThreadFactory;
import org.ballerinalang.stdlib.io.events.Event;
import org.ballerinalang.stdlib.io.events.EventResult;

public class EventManager {
    private static EventManager instance = new EventManager();
    private final ExecutorService workers;

    public static EventManager getInstance() {
        return instance;
    }

    private EventManager() {
        int numberOfCPU = Runtime.getRuntime().availableProcessors();
        float scalingFactor = 0.25f;
        boolean threadLimit = false;
        boolean minimumNumberOfThreads = true;
        boolean keepAliveTime = true;
        int numberOfThreads = (int)((float)numberOfCPU * 0.25f);
        numberOfThreads = numberOfThreads > 0 ? numberOfThreads : 1;
        BLangThreadFactory factory = new BLangThreadFactory("BLangIO");
        this.workers = new ThreadPoolExecutor(numberOfThreads, numberOfThreads, 1L, TimeUnit.MINUTES, new LinkedBlockingDeque<Runnable>(), (ThreadFactory)factory);
    }

    public void shutdown() {
        this.workers.shutdown();
    }

    public CompletableFuture<EventResult> publish(Event event) {
        return CompletableFuture.supplyAsync(event, this.workers);
    }
}

