/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.events.bytes;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.ballerinalang.stdlib.io.channels.base.Channel;
import org.ballerinalang.stdlib.io.events.Event;
import org.ballerinalang.stdlib.io.events.EventContext;
import org.ballerinalang.stdlib.io.events.EventResult;
import org.ballerinalang.stdlib.io.events.EventType;
import org.ballerinalang.stdlib.io.events.result.NumericResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteBytesEvent
implements Event {
    private Channel byteChannel;
    private ByteBuffer writeBuffer;
    private EventContext context;
    private static final Logger log = LoggerFactory.getLogger(WriteBytesEvent.class);

    public WriteBytesEvent(Channel byteChannel, byte[] content, int startOffset, EventContext context) {
        this.byteChannel = byteChannel;
        this.writeBuffer = ByteBuffer.wrap(content);
        this.writeBuffer.position(startOffset);
        this.context = context;
    }

    @Override
    public EventResult get() {
        NumericResult result;
        try {
            int numberOfBytesWritten = this.byteChannel.write(this.writeBuffer);
            result = new NumericResult(numberOfBytesWritten, this.context);
        }
        catch (IOException e) {
            log.error("Error occurred while reading bytes", (Throwable)e);
            this.context.setError(e);
            result = new NumericResult(this.context);
        }
        catch (Throwable e) {
            log.error("Unidentified error occurred while writing bytes", e);
            this.context.setError(e);
            result = new NumericResult(this.context);
        }
        return result;
    }

    @Override
    public int getChannelId() {
        return this.byteChannel.id();
    }

    @Override
    public boolean isSelectable() {
        return this.byteChannel.isSelectable();
    }

    @Override
    public EventType getType() {
        return EventType.WRITE;
    }

    @Override
    public Channel getChannel() {
        return this.byteChannel;
    }

    @Override
    public boolean remaining() {
        return this.byteChannel.remaining();
    }
}

