/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.events.data;

import java.io.IOException;
import org.ballerinalang.stdlib.io.channels.base.Channel;
import org.ballerinalang.stdlib.io.channels.base.DataChannel;
import org.ballerinalang.stdlib.io.channels.base.Representation;
import org.ballerinalang.stdlib.io.events.Event;
import org.ballerinalang.stdlib.io.events.EventContext;
import org.ballerinalang.stdlib.io.events.EventResult;
import org.ballerinalang.stdlib.io.events.EventType;
import org.ballerinalang.stdlib.io.events.result.DoubleResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadFloatEvent
implements Event {
    private DataChannel channel;
    private EventContext context;
    private Representation representation;
    private static final Logger log = LoggerFactory.getLogger(ReadFloatEvent.class);

    public ReadFloatEvent(DataChannel channel, Representation representation, EventContext context) {
        this.channel = channel;
        this.context = context;
        this.representation = representation;
    }

    @Override
    public EventResult get() {
        DoubleResult result;
        try {
            double numericResult = this.channel.readDouble(this.representation);
            result = new DoubleResult(numericResult, this.context);
        }
        catch (IOException e) {
            log.error("Error occurred while reading float", (Throwable)e);
            this.context.setError(e);
            result = new DoubleResult(this.context);
        }
        catch (Throwable e) {
            log.error("Unidentified error occurred while reading float", e);
            this.context.setError(e);
            result = new DoubleResult(this.context);
        }
        return result;
    }

    @Override
    public int getChannelId() {
        return this.channel.id();
    }

    @Override
    public boolean isSelectable() {
        return this.channel.isSelectable();
    }

    @Override
    public EventType getType() {
        return EventType.READ;
    }

    @Override
    public Channel getChannel() {
        return this.channel.getChannel();
    }

    @Override
    public boolean remaining() {
        return this.channel.remaining();
    }
}

