/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.events.data;

import java.io.IOException;
import org.ballerinalang.stdlib.io.channels.base.Channel;
import org.ballerinalang.stdlib.io.channels.base.DataChannel;
import org.ballerinalang.stdlib.io.channels.base.Representation;
import org.ballerinalang.stdlib.io.events.Event;
import org.ballerinalang.stdlib.io.events.EventContext;
import org.ballerinalang.stdlib.io.events.EventResult;
import org.ballerinalang.stdlib.io.events.EventType;
import org.ballerinalang.stdlib.io.events.result.LongResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadIntegerEvent
implements Event {
    private DataChannel channel;
    private EventContext context;
    private Representation representation;
    private static final Logger log = LoggerFactory.getLogger(ReadIntegerEvent.class);

    public ReadIntegerEvent(DataChannel channel, Representation representation, EventContext context) {
        this.channel = channel;
        this.context = context;
        this.representation = representation;
    }

    @Override
    public EventResult get() {
        LongResult result;
        try {
            long numericResult = this.channel.readLong(this.representation).getValue();
            result = new LongResult(numericResult, this.context);
        }
        catch (IOException e) {
            log.error("Error occurred while reading integer", (Throwable)e);
            this.context.setError(e);
            result = new LongResult(this.context);
        }
        catch (Throwable e) {
            log.error("Unidentified error occurred while reading integer", e);
            this.context.setError(e);
            result = new LongResult(this.context);
        }
        return result;
    }

    @Override
    public int getChannelId() {
        return this.channel.id();
    }

    @Override
    public boolean isSelectable() {
        return this.channel.isSelectable();
    }

    @Override
    public EventType getType() {
        return EventType.READ;
    }

    @Override
    public Channel getChannel() {
        return this.channel.getChannel();
    }

    @Override
    public boolean remaining() {
        return this.channel.remaining();
    }
}

