/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.events.data;

import java.io.IOException;
import org.ballerinalang.stdlib.io.channels.base.Channel;
import org.ballerinalang.stdlib.io.channels.base.DataChannel;
import org.ballerinalang.stdlib.io.events.Event;
import org.ballerinalang.stdlib.io.events.EventContext;
import org.ballerinalang.stdlib.io.events.EventResult;
import org.ballerinalang.stdlib.io.events.EventType;
import org.ballerinalang.stdlib.io.events.result.AlphaResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadStringEvent
implements Event {
    private DataChannel channel;
    private EventContext context;
    private int nBytes;
    private String encoding;
    private static final Logger log = LoggerFactory.getLogger(ReadStringEvent.class);

    public ReadStringEvent(DataChannel channel, EventContext context, int nBytes, String encoding) {
        this.channel = channel;
        this.context = context;
        this.nBytes = nBytes;
        this.encoding = encoding;
    }

    @Override
    public EventResult get() {
        AlphaResult result;
        try {
            if (this.channel.hasReachedEnd()) {
                if (log.isDebugEnabled()) {
                    log.debug("Channel " + this.channel.hashCode() + " reached it's end");
                }
                this.context.setError(new Throwable("io.EOF"));
                result = new AlphaResult(this.context);
            } else {
                String alphaResult = this.channel.readString(this.nBytes, this.encoding);
                result = new AlphaResult(alphaResult, this.context);
            }
        }
        catch (IOException e) {
            log.error("Error occurred while reading string", (Throwable)e);
            this.context.setError(e);
            result = new AlphaResult(this.context);
        }
        catch (Throwable e) {
            log.error("Unidentified error occurred while reading string", e);
            this.context.setError(e);
            result = new AlphaResult(this.context);
        }
        return result;
    }

    @Override
    public int getChannelId() {
        return this.channel.id();
    }

    @Override
    public boolean isSelectable() {
        return this.channel.isSelectable();
    }

    @Override
    public EventType getType() {
        return EventType.READ;
    }

    @Override
    public Channel getChannel() {
        return this.channel.getChannel();
    }

    @Override
    public boolean remaining() {
        return this.channel.remaining();
    }
}

