/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.events.data;

import java.io.IOException;
import org.ballerinalang.stdlib.io.channels.base.Channel;
import org.ballerinalang.stdlib.io.channels.base.DataChannel;
import org.ballerinalang.stdlib.io.channels.base.Representation;
import org.ballerinalang.stdlib.io.events.Event;
import org.ballerinalang.stdlib.io.events.EventContext;
import org.ballerinalang.stdlib.io.events.EventResult;
import org.ballerinalang.stdlib.io.events.EventType;
import org.ballerinalang.stdlib.io.events.result.NumericResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteIntegerEvent
implements Event {
    private DataChannel channel;
    private EventContext context;
    private long value;
    private Representation representation;
    private static final Logger log = LoggerFactory.getLogger(WriteIntegerEvent.class);

    public WriteIntegerEvent(DataChannel dataChannel, long value, Representation representation, EventContext context) {
        this.channel = dataChannel;
        this.context = context;
        this.value = value;
        this.representation = representation;
    }

    @Override
    public EventResult get() {
        NumericResult result;
        try {
            this.channel.writeLong(this.value, this.representation);
            result = new NumericResult(this.context);
        }
        catch (IOException e) {
            log.error("Error occurred while writing int", (Throwable)e);
            this.context.setError(e);
            result = new NumericResult(this.context);
        }
        catch (Throwable e) {
            log.error("Unidentified error occurred while writing int", e);
            this.context.setError(e);
            result = new NumericResult(this.context);
        }
        return result;
    }

    @Override
    public int getChannelId() {
        return this.channel.id();
    }

    @Override
    public boolean isSelectable() {
        return this.channel.isSelectable();
    }

    @Override
    public EventType getType() {
        return EventType.WRITE;
    }

    @Override
    public Channel getChannel() {
        return this.channel.getChannel();
    }

    @Override
    public boolean remaining() {
        return this.channel.remaining();
    }
}

