/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.events.records;

import java.io.IOException;
import java.util.ArrayList;
import org.ballerinalang.stdlib.io.channels.base.Channel;
import org.ballerinalang.stdlib.io.channels.base.DelimitedRecordChannel;
import org.ballerinalang.stdlib.io.events.Event;
import org.ballerinalang.stdlib.io.events.EventContext;
import org.ballerinalang.stdlib.io.events.EventResult;
import org.ballerinalang.stdlib.io.events.EventType;
import org.ballerinalang.stdlib.io.events.result.ListResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelimitedRecordReadAllEvent
implements Event {
    private DelimitedRecordChannel channel;
    private EventContext context;
    private static final Logger log = LoggerFactory.getLogger(DelimitedRecordReadAllEvent.class);

    public DelimitedRecordReadAllEvent(DelimitedRecordChannel channel, EventContext context) {
        this.channel = channel;
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EventResult get() {
        try {
            ListResult result;
            ArrayList<String[]> records = new ArrayList<String[]>();
            while (this.channel.hasNext()) {
                records.add(this.channel.read());
            }
            ListResult listResult = result = new ListResult(records, this.context);
            return listResult;
        }
        catch (IOException e) {
            ListResult result;
            log.error("Error occurred while reading from the DelimitedRecordChannel", (Throwable)e);
            this.context.setError(e);
            ListResult listResult = result = new ListResult(this.context);
            return listResult;
        }
        catch (Throwable e) {
            ListResult result;
            log.error("Unidentified error occurred while reading all delimited records", e);
            this.context.setError(e);
            ListResult listResult = result = new ListResult(this.context);
            return listResult;
        }
        finally {
            try {
                this.channel.close();
            }
            catch (IOException e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public int getChannelId() {
        return this.channel.id();
    }

    @Override
    public boolean isSelectable() {
        return this.channel.isSelectable();
    }

    @Override
    public EventType getType() {
        return EventType.READ;
    }

    @Override
    public Channel getChannel() {
        return this.channel.getChannel();
    }

    @Override
    public boolean remaining() {
        return this.channel.remaining();
    }
}

