/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.nativeimpl;

import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.stdlib.io.channels.base.CharacterChannel;
import org.ballerinalang.stdlib.io.channels.base.DelimitedRecordChannel;
import org.ballerinalang.stdlib.io.csv.Format;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(orgName="ballerina", packageName="io", functionName="init", receiver=@Receiver(type=TypeKind.OBJECT, structType="ReadableTextRecordChannel", structPackage="ballerina/io"), args={@Argument(name="charChannel", type=TypeKind.OBJECT, structType="ReadableCharacterChannel", structPackage="ballerina/io"), @Argument(name="recordSeparator", type=TypeKind.STRING), @Argument(name="fieldSeparator", type=TypeKind.STRING)}, returnType={@ReturnType(type=TypeKind.OBJECT, structType="ReadableRecordChannel", structPackage="ballerina/io"), @ReturnType(type=TypeKind.RECORD, structType="Error", structPackage="ballerina/io")}, isPublic=true)
public class CreateReadableDelimitedRecordChannel {
    private static final Logger log = LoggerFactory.getLogger(CreateReadableDelimitedRecordChannel.class);
    private static final String DEFAULT = "default";

    public static void init(Strand strand, ObjectValue textRecordChannel, ObjectValue characterChannelInfo, String fieldSeparator, String recordSeparator, String format) {
        try {
            CharacterChannel characterChannel = (CharacterChannel)characterChannelInfo.getNativeData("char_channel");
            DelimitedRecordChannel delimitedRecordChannel = DEFAULT.equals(format) ? new DelimitedRecordChannel(characterChannel, recordSeparator, fieldSeparator) : new DelimitedRecordChannel(characterChannel, Format.valueOf(format));
            textRecordChannel.addNativeData("txt_record", (Object)delimitedRecordChannel);
        }
        catch (Throwable e) {
            String message = "Error occurred while converting character channel to textRecord channel:" + e.getMessage();
            log.error(message, e);
            throw new BallerinaException(message, e);
        }
    }
}

