/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.nativeimpl;

import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.connector.NonBlockingCallback;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.stdlib.io.channels.base.CharacterChannel;
import org.ballerinalang.stdlib.io.events.EventContext;
import org.ballerinalang.stdlib.io.events.EventRegister;
import org.ballerinalang.stdlib.io.events.EventResult;
import org.ballerinalang.stdlib.io.events.Register;
import org.ballerinalang.stdlib.io.events.characters.ReadCharactersEvent;
import org.ballerinalang.stdlib.io.utils.IOUtils;

@BallerinaFunction(orgName="ballerina", packageName="io", functionName="read", receiver=@Receiver(type=TypeKind.OBJECT, structType="ReadableCharacterChannel", structPackage="ballerina/io"), args={@Argument(name="numberOfChars", type=TypeKind.INT)}, returnType={@ReturnType(type=TypeKind.STRING), @ReturnType(type=TypeKind.ERROR)}, isPublic=true)
public class ReadCharacters {
    public static Object read(Strand strand, ObjectValue channel, long numberOfCharacters) {
        CharacterChannel characterChannel = (CharacterChannel)channel.getNativeData("char_channel");
        EventContext eventContext = new EventContext(new NonBlockingCallback(strand));
        ReadCharactersEvent event = new ReadCharactersEvent(characterChannel, (int)numberOfCharacters, eventContext);
        Register register = EventRegister.getFactory().register(event, ReadCharacters::readCharacterResponse);
        eventContext.setRegister(register);
        register.submit();
        return null;
    }

    private static EventResult readCharacterResponse(EventResult<String, EventContext> result) {
        EventContext eventContext = result.getContext();
        NonBlockingCallback callback = eventContext.getNonBlockingCallback();
        Throwable error = eventContext.getError();
        if (null != error) {
            callback.setReturnValues((Object)IOUtils.createError(error.getMessage()));
        } else {
            callback.setReturnValues((Object)result.getResponse());
        }
        IOUtils.validateChannelState(eventContext);
        callback.notifySuccess();
        return result;
    }
}

