/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.nativeimpl;

import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.connector.NonBlockingCallback;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.stdlib.io.channels.base.DataChannel;
import org.ballerinalang.stdlib.io.channels.base.Representation;
import org.ballerinalang.stdlib.io.events.EventContext;
import org.ballerinalang.stdlib.io.events.EventRegister;
import org.ballerinalang.stdlib.io.events.EventResult;
import org.ballerinalang.stdlib.io.events.Register;
import org.ballerinalang.stdlib.io.events.data.ReadFloatEvent;
import org.ballerinalang.stdlib.io.utils.IOUtils;

@BallerinaFunction(orgName="ballerina", packageName="io", functionName="readFloat32", receiver=@Receiver(type=TypeKind.OBJECT, structType="ReadableDataChannel", structPackage="ballerina/io"), isPublic=true)
public class ReadFloat32 {
    public static Object readFloat32(Strand strand, ObjectValue dataChannelObj) {
        DataChannel channel = (DataChannel)dataChannelObj.getNativeData("data_channel");
        EventContext eventContext = new EventContext(new NonBlockingCallback(strand));
        ReadFloatEvent event = new ReadFloatEvent(channel, Representation.BIT_32, eventContext);
        Register register = EventRegister.getFactory().register(event, ReadFloat32::readChannelResponse);
        eventContext.setRegister(register);
        register.submit();
        return null;
    }

    private static EventResult readChannelResponse(EventResult<Double, EventContext> result) {
        EventContext eventContext = result.getContext();
        Throwable error = eventContext.getError();
        NonBlockingCallback callback = eventContext.getNonBlockingCallback();
        if (null != error) {
            callback.setReturnValues((Object)IOUtils.createError(error.getMessage()));
        } else {
            callback.setReturnValues((Object)result.getResponse());
        }
        IOUtils.validateChannelState(eventContext);
        callback.notifySuccess();
        return result;
    }
}

