/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.nativeimpl;

import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.connector.NonBlockingCallback;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.stdlib.io.channels.base.Channel;
import org.ballerinalang.stdlib.io.events.EventContext;
import org.ballerinalang.stdlib.io.events.EventRegister;
import org.ballerinalang.stdlib.io.events.EventResult;
import org.ballerinalang.stdlib.io.events.Register;
import org.ballerinalang.stdlib.io.events.bytes.WriteBytesEvent;
import org.ballerinalang.stdlib.io.utils.IOUtils;

@BallerinaFunction(orgName="ballerina", packageName="io", functionName="write", receiver=@Receiver(type=TypeKind.OBJECT, structType="WritableByteChannel", structPackage="ballerina/io"), args={@Argument(name="content", type=TypeKind.ARRAY, elementType=TypeKind.BYTE), @Argument(name="offset", type=TypeKind.INT)}, returnType={@ReturnType(type=TypeKind.INT), @ReturnType(type=TypeKind.ERROR)}, isPublic=true)
public class WriteBytes {
    public static Object write(Strand strand, ObjectValue channel, ArrayValue content, long offset) {
        Channel byteChannel = (Channel)channel.getNativeData("byteChannel");
        EventContext eventContext = new EventContext(new NonBlockingCallback(strand));
        WriteBytesEvent writeBytesEvent = new WriteBytesEvent(byteChannel, content.getBytes(), (int)offset, eventContext);
        Register register = EventRegister.getFactory().register(writeBytesEvent, WriteBytes::writeByteResponse);
        eventContext.setRegister(register);
        register.submit();
        return null;
    }

    private static EventResult writeByteResponse(EventResult<Integer, EventContext> result) {
        EventContext eventContext = result.getContext();
        NonBlockingCallback callback = eventContext.getNonBlockingCallback();
        Throwable error = eventContext.getError();
        if (null != error) {
            callback.setReturnValues((Object)IOUtils.createError(error.getMessage()));
        } else {
            callback.setReturnValues((Object)result.getResponse());
        }
        callback.notifySuccess();
        return result;
    }
}

