/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.nativeimpl;

import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.connector.NonBlockingCallback;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.stdlib.io.channels.base.DataChannel;
import org.ballerinalang.stdlib.io.events.EventContext;
import org.ballerinalang.stdlib.io.events.EventRegister;
import org.ballerinalang.stdlib.io.events.EventResult;
import org.ballerinalang.stdlib.io.events.Register;
import org.ballerinalang.stdlib.io.events.data.WriteStringEvent;
import org.ballerinalang.stdlib.io.utils.IOUtils;

@BallerinaFunction(orgName="ballerina", packageName="io", functionName="writeString", receiver=@Receiver(type=TypeKind.OBJECT, structType="WritableDataChannel", structPackage="ballerina.io"), args={@Argument(name="value", type=TypeKind.STRING), @Argument(name="encoding", type=TypeKind.STRING)}, isPublic=true)
public class WriteString {
    public static Object writeString(Strand strand, ObjectValue dataChannelObj, String value, String encoding) {
        DataChannel channel = (DataChannel)dataChannelObj.getNativeData("data_channel");
        EventContext eventContext = new EventContext(new NonBlockingCallback(strand));
        WriteStringEvent writeStringEvent = new WriteStringEvent(channel, value, encoding, eventContext);
        Register register = EventRegister.getFactory().register(writeStringEvent, WriteString::writeStringResponse);
        eventContext.setRegister(register);
        register.submit();
        return null;
    }

    private static EventResult writeStringResponse(EventResult<Long, EventContext> result) {
        EventContext eventContext = result.getContext();
        NonBlockingCallback callback = eventContext.getNonBlockingCallback();
        Throwable error = eventContext.getError();
        if (null != error) {
            callback.setReturnValues((Object)IOUtils.createError(error.getMessage()));
        } else {
            callback.setReturnValues(null);
        }
        callback.notifySuccess();
        return result;
    }
}

