/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.utils;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.stdlib.io.channels.FileIOChannel;
import org.ballerinalang.stdlib.io.channels.base.Channel;
import org.ballerinalang.stdlib.io.channels.base.CharacterChannel;
import org.ballerinalang.stdlib.io.channels.base.DelimitedRecordChannel;
import org.ballerinalang.stdlib.io.csv.Format;
import org.ballerinalang.stdlib.io.events.EventContext;
import org.ballerinalang.stdlib.io.events.EventExecutor;
import org.ballerinalang.stdlib.io.events.EventManager;
import org.ballerinalang.stdlib.io.events.EventResult;
import org.ballerinalang.stdlib.io.events.Register;
import org.ballerinalang.stdlib.io.events.bytes.ReadBytesEvent;
import org.ballerinalang.stdlib.io.events.bytes.WriteBytesEvent;
import org.ballerinalang.stdlib.io.events.characters.WriteCharactersEvent;
import org.ballerinalang.stdlib.io.utils.IOConstants;

public class IOUtils {
    private static final String PACKAGE_IO = "ballerina/io";

    public static ErrorValue createError(Object ... values) {
        return BallerinaErrors.createError((String)IOConstants.ErrorCode.GenericError.errorCode(), IOUtils.createDetailRecord(values));
    }

    public static ErrorValue createError(String errorMsg) {
        return BallerinaErrors.createError((String)IOConstants.ErrorCode.GenericError.errorCode(), IOUtils.createDetailRecord(errorMsg, null));
    }

    public static ErrorValue createError(IOConstants.ErrorCode code, String errorMsg) {
        return BallerinaErrors.createError((String)code.errorCode(), IOUtils.createDetailRecord(errorMsg, null));
    }

    private static MapValue<String, Object> createDetailRecord(Object ... values) {
        MapValue detail = BallerinaValues.createRecordValue((String)PACKAGE_IO, (String)"Detail");
        return BallerinaValues.createRecord((MapValue)detail, (Object[])values);
    }

    public static int writeFull(Channel channel, byte[] content, int offset, EventContext context) throws ExecutionException, InterruptedException {
        while ((offset += IOUtils.write(channel, content, offset, context)) < content.length) {
        }
        return offset;
    }

    private static int write(Channel channel, byte[] content, int offset, EventContext context) throws InterruptedException, ExecutionException {
        WriteBytesEvent writeBytesEvent = new WriteBytesEvent(channel, content, offset, context);
        CompletableFuture<EventResult> future = EventManager.getInstance().publish(writeBytesEvent);
        EventResult eventResponse = future.get();
        offset += ((Integer)eventResponse.getResponse()).intValue();
        Throwable error = ((EventContext)eventResponse.getContext()).getError();
        if (null != error) {
            throw new ExecutionException(error);
        }
        return offset;
    }

    public static boolean validateChannelState(EventContext event) {
        Register register = event.getRegister();
        EventExecutor exec = register.getExec();
        Channel channel = exec.getChannel();
        if (!channel.getByteChannel().isOpen()) {
            register.discard();
            return true;
        }
        return false;
    }

    public static void writeFull(CharacterChannel characterChannel, String payload, EventContext eventContext) throws BallerinaException {
        try {
            WriteCharactersEvent event;
            CompletableFuture<EventResult> future;
            EventResult eventResult;
            int numberOfCharsWritten;
            int totalNumberOfCharsWritten = 0;
            int lengthOfPayload = payload.getBytes().length;
            do {
                event = new WriteCharactersEvent(characterChannel, payload, 0, eventContext);
            } while ((totalNumberOfCharsWritten += (numberOfCharsWritten = ((Integer)(eventResult = (future = EventManager.getInstance().publish(event)).get()).getResponse()).intValue())) != lengthOfPayload && numberOfCharsWritten != 0);
            if (totalNumberOfCharsWritten != lengthOfPayload) {
                String message = "JSON payload was partially written expected: " + lengthOfPayload + ", written : " + totalNumberOfCharsWritten;
                throw new BallerinaException(message);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new BallerinaException((Throwable)e);
        }
    }

    public static int readFull(Channel channel, byte[] content, EventContext context) throws InterruptedException, ExecutionException {
        int numberOfBytesToRead = content.length;
        int nBytesRead = 0;
        while ((nBytesRead += IOUtils.read(channel, content, context)) < numberOfBytesToRead && !channel.hasReachedEnd()) {
        }
        return nBytesRead;
    }

    private static int read(Channel channel, byte[] content, EventContext context) throws InterruptedException, ExecutionException {
        ReadBytesEvent event = new ReadBytesEvent(channel, content, context);
        CompletableFuture<EventResult> future = EventManager.getInstance().publish(event);
        EventResult eventResponse = future.get();
        int numberOfBytesRead = (Integer)eventResponse.getResponse();
        Throwable error = ((EventContext)eventResponse.getContext()).getError();
        if (null != error) {
            throw new ExecutionException(error);
        }
        return numberOfBytesRead;
    }

    private static void createDirsExtended(Path path) {
        Path parent = path.getParent();
        if (parent != null && !Files.exists(parent, new LinkOption[0])) {
            try {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new BallerinaException("Error in creating directory.", (Throwable)e);
            }
        }
    }

    public static FileChannel openFileChannelExtended(Path path, String accessMode) throws IOException {
        String accessLC = accessMode.toLowerCase(Locale.getDefault());
        HashSet<StandardOpenOption> opts = new HashSet<StandardOpenOption>();
        if (accessLC.contains("r")) {
            if (!Files.exists(path, new LinkOption[0])) {
                throw new BallerinaException("file not found: " + path);
            }
            if (!Files.isReadable(path)) {
                throw new BallerinaException("file is not readable: " + path);
            }
            opts.add(StandardOpenOption.READ);
        }
        boolean write = accessLC.contains("w");
        boolean append = accessLC.contains("a");
        if (write || append) {
            if (Files.exists(path, new LinkOption[0]) && !Files.isWritable(path)) {
                throw new BallerinaException("file is not writable: " + path);
            }
            IOUtils.createDirsExtended(path);
            opts.add(StandardOpenOption.CREATE);
            if (append) {
                opts.add(StandardOpenOption.APPEND);
            } else {
                opts.add(StandardOpenOption.WRITE);
            }
        }
        return FileChannel.open(path, opts, new FileAttribute[0]);
    }

    public static DelimitedRecordChannel createDelimitedRecordChannelExtended(String filePath, String encoding, String mode, Format format) throws IOException {
        Path path = Paths.get(filePath, new String[0]);
        FileChannel sourceChannel = IOUtils.openFileChannelExtended(path, mode);
        FileIOChannel fileIOChannel = new FileIOChannel(sourceChannel);
        CharacterChannel characterChannel = new CharacterChannel(fileIOChannel, Charset.forName(encoding).name());
        return new DelimitedRecordChannel(characterChannel, format);
    }
}

