/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.nativeimpl;

import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.stdlib.io.channels.base.Channel;
import org.ballerinalang.stdlib.io.channels.base.CharacterChannel;
import org.ballerinalang.stdlib.io.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(orgName="ballerina", packageName="io", functionName="init", receiver=@Receiver(type=TypeKind.OBJECT, structType="WritableCharacterChannel", structPackage="ballerina/io"), args={@Argument(name="byteChannel", type=TypeKind.OBJECT, structType="WritableByteChannel", structPackage="ballerina/io"), @Argument(name="encoding", type=TypeKind.STRING)}, isPublic=true)
public class CreateWritableCharacterChannel {
    private static final Logger log = LoggerFactory.getLogger(CreateWritableCharacterChannel.class);

    public static void init(Strand strand, ObjectValue characterChannel, ObjectValue byteChannelInfo, String encoding) {
        try {
            Channel byteChannel = (Channel)byteChannelInfo.getNativeData("byteChannel");
            CharacterChannel bCharacterChannel = new CharacterChannel(byteChannel, encoding);
            characterChannel.addNativeData("char_channel", (Object)bCharacterChannel);
        }
        catch (Exception e) {
            String message = "error occurred while converting byte channel to character channel: " + e.getMessage();
            log.error(message, (Throwable)e);
            throw IOUtils.createError(message);
        }
    }
}

