/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.nativeimpl;

import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.stdlib.io.channels.base.CharacterChannel;
import org.ballerinalang.stdlib.io.channels.base.DelimitedRecordChannel;
import org.ballerinalang.stdlib.io.csv.Format;
import org.ballerinalang.stdlib.io.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(orgName="ballerina", packageName="io", functionName="init", receiver=@Receiver(type=TypeKind.OBJECT, structType="WritableTextRecordChannel", structPackage="ballerina/io"), args={@Argument(name="channel", type=TypeKind.OBJECT, structType="WritableCharacterChannel", structPackage="ballerina/io"), @Argument(name="recordSeparator", type=TypeKind.STRING), @Argument(name="fieldSeparator", type=TypeKind.STRING)}, isPublic=true)
public class CreateWritableDelimitedRecordChannel {
    private static final Logger log = LoggerFactory.getLogger(CreateWritableDelimitedRecordChannel.class);
    private static final String DEFAULT = "default";

    public static void init(Strand strand, ObjectValue textRecordChannel, ObjectValue characterChannelInfo, String recordSeparator, String fieldSeparator, String format) {
        try {
            CharacterChannel characterChannel = (CharacterChannel)characterChannelInfo.getNativeData("char_channel");
            DelimitedRecordChannel delimitedRecordChannel = DEFAULT.equals(format) ? new DelimitedRecordChannel(characterChannel, recordSeparator, fieldSeparator) : new DelimitedRecordChannel(characterChannel, Format.valueOf(format));
            textRecordChannel.addNativeData("txt_record", (Object)delimitedRecordChannel);
        }
        catch (Exception e) {
            String message = "error occurred while converting character channel to textRecord channel: " + e.getMessage();
            log.error(message, (Throwable)e);
            throw IOUtils.createError(message);
        }
    }
}

