/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.nativeimpl;

import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.stdlib.io.channels.base.DelimitedRecordChannel;
import org.ballerinalang.stdlib.io.utils.BallerinaIOException;
import org.ballerinalang.stdlib.io.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(orgName="ballerina", packageName="io", functionName="hasNext", receiver=@Receiver(type=TypeKind.OBJECT, structType="ReadableTextRecordChannel", structPackage="ballerina/io"), returnType={@ReturnType(type=TypeKind.BOOLEAN)}, isPublic=true)
public class HasNextTextRecord {
    private static final Logger log = LoggerFactory.getLogger(HasNextTextRecord.class);

    public static boolean hasNext(Strand strand, ObjectValue channel) {
        DelimitedRecordChannel textRecordChannel;
        if (channel.getNativeData("txt_record") != null && !(textRecordChannel = (DelimitedRecordChannel)channel.getNativeData("txt_record")).hasReachedEnd()) {
            try {
                return textRecordChannel.hasNext();
            }
            catch (BallerinaIOException e) {
                String msg = "error occurred while checking hasNext on ReadableTextRecordChannel: " + e.getMessage();
                log.error(msg, (Throwable)e);
                throw IOUtils.createError(msg);
            }
        }
        return false;
    }
}

