/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.nativeimpl;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.stdlib.io.channels.base.Channel;
import org.ballerinalang.stdlib.io.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(orgName="ballerina", packageName="io", functionName="read", receiver=@Receiver(type=TypeKind.OBJECT, structType="ReadableByteChannel", structPackage="ballerina/io"), args={@Argument(name="nBytes", type=TypeKind.INT)}, returnType={@ReturnType(type=TypeKind.ARRAY, elementType=TypeKind.BYTE), @ReturnType(type=TypeKind.INT), @ReturnType(type=TypeKind.ERROR)}, isPublic=true)
public class ReadBytes {
    private static final Logger log = LoggerFactory.getLogger(ReadBytes.class);

    public static Object read(Strand strand, ObjectValue channel, long nBytes) {
        int arraySize = nBytes <= 0L ? 16384 : (int)nBytes;
        Channel byteChannel = (Channel)channel.getNativeData("byteChannel");
        ByteBuffer content = ByteBuffer.wrap(new byte[arraySize]);
        if (byteChannel.hasReachedEnd()) {
            return IOUtils.createEoFError();
        }
        try {
            byteChannel.read(content);
            return new ArrayValue(ReadBytes.getContentData(content));
        }
        catch (Exception e) {
            String msg = "error occurred while reading bytes from the channel. " + e.getMessage();
            log.error(msg, (Throwable)e);
            return IOUtils.createError(msg);
        }
    }

    private static byte[] getContentData(ByteBuffer contentBuffer) {
        int bufferSize = contentBuffer.limit();
        int readPosition = contentBuffer.position();
        byte[] content = contentBuffer.array();
        boolean startPosition = false;
        if (readPosition == bufferSize) {
            return content;
        }
        return Arrays.copyOfRange(content, 0, readPosition);
    }
}

