/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.nativeimpl;

import java.io.Reader;
import org.ballerinalang.jvm.JSONParser;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.stdlib.io.channels.base.CharacterChannel;
import org.ballerinalang.stdlib.io.readers.CharacterChannelReader;
import org.ballerinalang.stdlib.io.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(orgName="ballerina", packageName="io", functionName="readJson", receiver=@Receiver(type=TypeKind.OBJECT, structType="ReadableCharacterChannel", structPackage="ballerina/io"), isPublic=true)
public class ReadJson {
    private static final Logger log = LoggerFactory.getLogger(ReadJson.class);

    public static Object readJson(Strand strand, ObjectValue channel) {
        CharacterChannel charChannel = (CharacterChannel)channel.getNativeData("char_channel");
        CharacterChannelReader reader = new CharacterChannelReader(charChannel);
        try {
            return JSONParser.parse((Reader)reader);
        }
        catch (BallerinaException e) {
            log.error("unable to read json from character channel", (Throwable)e);
            return IOUtils.createError(e);
        }
    }
}

