/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.nativeimpl;

import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.stdlib.io.channels.base.DelimitedRecordChannel;
import org.ballerinalang.stdlib.io.csv.Format;
import org.ballerinalang.stdlib.io.utils.BallerinaIOException;
import org.ballerinalang.stdlib.io.utils.IOConstants;
import org.ballerinalang.stdlib.io.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(orgName="ballerina", packageName="io", functionName="createCsvChannel", args={@Argument(name="path", type=TypeKind.STRING), @Argument(name="mode", type=TypeKind.STRING), @Argument(name="rf", type=TypeKind.STRING), @Argument(name="charset", type=TypeKind.STRING)}, returnType={@ReturnType(type=TypeKind.OBJECT, structType="DelimitedRecordChannel", structPackage="ballerina/io"), @ReturnType(type=TypeKind.ERROR)}, isPublic=true)
public class CreateCsvChannel {
    private static final Logger log = LoggerFactory.getLogger(CreateCsvChannel.class);
    private static final String STRUCT_TYPE = "DelimitedRecordChannel";

    public static Object createCsvChannel(Strand strand, String filePath, String accessMode, String format, String charset) {
        try {
            ObjectValue textRecordChannel = BallerinaValues.createObjectValue((BPackage)IOConstants.IO_PACKAGE_ID, (String)STRUCT_TYPE, (Object[])new Object[0]);
            DelimitedRecordChannel delimitedRecordChannel = IOUtils.createDelimitedRecordChannelExtended(filePath, charset, accessMode, Format.valueOf(format));
            textRecordChannel.addNativeData("txt_record", (Object)delimitedRecordChannel);
            return textRecordChannel;
        }
        catch (BallerinaIOException e) {
            String message = "error occurred while converting character channel to textRecord channel:" + e.getMessage();
            log.error(message, (Throwable)e);
            return IOUtils.createError(message);
        }
        catch (ErrorValue e) {
            return e;
        }
    }
}

