/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.nativeimpl;

import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.stdlib.io.channels.base.DelimitedRecordChannel;
import org.ballerinalang.stdlib.io.utils.BallerinaIOException;
import org.ballerinalang.stdlib.io.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(orgName="ballerina", packageName="io", functionName="getNext", receiver=@Receiver(type=TypeKind.OBJECT, structType="ReadableTextRecordChannel", structPackage="ballerina/io"), returnType={@ReturnType(type=TypeKind.ARRAY, elementType=TypeKind.STRING), @ReturnType(type=TypeKind.ERROR)}, isPublic=true)
public class NextTextRecord {
    private static final Logger log = LoggerFactory.getLogger(NextTextRecord.class);

    public static Object getNext(Strand strand, ObjectValue channel) {
        DelimitedRecordChannel delimitedRecordChannel = (DelimitedRecordChannel)channel.getNativeData("txt_record");
        if (delimitedRecordChannel.hasReachedEnd()) {
            return IOUtils.createEoFError();
        }
        try {
            return new ArrayValue(delimitedRecordChannel.read());
        }
        catch (BallerinaIOException e) {
            log.error("error occurred while reading next text record from ReadableTextRecordChannel", (Throwable)e);
            return IOUtils.createError(e);
        }
    }
}

