/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.nativeimpl;

import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.stdlib.io.channels.AbstractNativeChannel;
import org.ballerinalang.stdlib.io.channels.FileIOChannel;
import org.ballerinalang.stdlib.io.channels.base.Channel;
import org.ballerinalang.stdlib.io.utils.BallerinaIOException;
import org.ballerinalang.stdlib.io.utils.IOUtils;

@BallerinaFunction(orgName="ballerina", packageName="io", functionName="openWritableFile", args={@Argument(name="path", type=TypeKind.STRING), @Argument(name="append", type=TypeKind.BOOLEAN)}, returnType={@ReturnType(type=TypeKind.OBJECT, structType="WritableByteChannel", structPackage="ballerina/io")}, isPublic=true)
public class OpenWritableFile
extends AbstractNativeChannel {
    private static final String WRITE_ACCESS_MODE = "w";
    private static final String APPEND_ACCESS_MODE = "a";

    public static Object openWritableFile(Strand strand, String pathUrl, boolean accessMode) {
        try {
            return OpenWritableFile.createChannel(OpenWritableFile.inFlow(pathUrl, accessMode));
        }
        catch (BallerinaException | BallerinaIOException e) {
            return IOUtils.createError(e);
        }
        catch (ErrorValue e) {
            return e;
        }
    }

    private static Channel inFlow(String pathUrl, boolean accessMode) throws BallerinaIOException {
        Path path = Paths.get(pathUrl, new String[0]);
        FileChannel fileChannel = accessMode ? IOUtils.openFileChannelExtended(path, APPEND_ACCESS_MODE) : IOUtils.openFileChannelExtended(path, WRITE_ACCESS_MODE);
        return new FileIOChannel(fileChannel);
    }
}

