/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.nativeimpl;

import java.io.IOException;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.stdlib.io.channels.base.DataChannel;
import org.ballerinalang.stdlib.io.channels.base.Representation;
import org.ballerinalang.stdlib.io.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(orgName="ballerina", packageName="io", functionName="readInt64", receiver=@Receiver(type=TypeKind.OBJECT, structType="ReadableDataChannel", structPackage="ballerina/io"), isPublic=true)
public class ReadInt64 {
    private static final Logger log = LoggerFactory.getLogger(ReadInt64.class);

    public static Object readInt64(Strand strand, ObjectValue dataChannelObj) {
        DataChannel channel = (DataChannel)dataChannelObj.getNativeData("data_channel");
        try {
            return channel.readLong(Representation.BIT_64).getValue();
        }
        catch (IOException e) {
            log.error("error occurred while reading Int64", (Throwable)e);
            return IOUtils.createError(e);
        }
    }
}

