/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.nativeimpl;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.stdlib.io.channels.base.Channel;
import org.ballerinalang.stdlib.io.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(orgName="ballerina", packageName="io", functionName="write", receiver=@Receiver(type=TypeKind.OBJECT, structType="WritableByteChannel", structPackage="ballerina/io"), args={@Argument(name="content", type=TypeKind.ARRAY, elementType=TypeKind.BYTE), @Argument(name="offset", type=TypeKind.INT)}, returnType={@ReturnType(type=TypeKind.INT), @ReturnType(type=TypeKind.ERROR)}, isPublic=true)
public class WriteBytes {
    private static final Logger log = LoggerFactory.getLogger(WriteBytes.class);

    public static Object write(Strand strand, ObjectValue channel, ArrayValue content, long offset) {
        Channel byteChannel = (Channel)channel.getNativeData("byteChannel");
        ByteBuffer writeBuffer = ByteBuffer.wrap(content.getBytes());
        writeBuffer.position((int)offset);
        try {
            return byteChannel.write(writeBuffer);
        }
        catch (IOException e) {
            log.error("Error occurred while writing to the channel.", (Throwable)e);
            return IOUtils.createError(e);
        }
    }
}

