/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.nativeimpl;

import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.stdlib.io.channels.base.CharacterChannel;
import org.ballerinalang.stdlib.io.utils.BallerinaIOException;
import org.ballerinalang.stdlib.io.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(orgName="ballerina", packageName="io", functionName="read", receiver=@Receiver(type=TypeKind.OBJECT, structType="ReadableCharacterChannel", structPackage="ballerina/io"), args={@Argument(name="numberOfChars", type=TypeKind.INT)}, returnType={@ReturnType(type=TypeKind.STRING), @ReturnType(type=TypeKind.ERROR)}, isPublic=true)
public class ReadCharacters {
    private static final Logger log = LoggerFactory.getLogger(ReadCharacters.class);

    public static Object read(Strand strand, ObjectValue channel, long numberOfCharacters) {
        CharacterChannel characterChannel = (CharacterChannel)channel.getNativeData("char_channel");
        if (characterChannel.hasReachedEnd()) {
            return IOUtils.createEoFError();
        }
        try {
            return characterChannel.read((int)numberOfCharacters);
        }
        catch (BallerinaIOException e) {
            log.error("error occurred while reading characters.", (Throwable)e);
            return IOUtils.createError(e);
        }
    }
}

