/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.nativeimpl;

import java.io.IOException;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.stdlib.io.channels.base.DataChannel;
import org.ballerinalang.stdlib.io.channels.base.Representation;
import org.ballerinalang.stdlib.io.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(orgName="ballerina", packageName="io", functionName="writeFloat64", receiver=@Receiver(type=TypeKind.OBJECT, structType="WritableDataChannel", structPackage="ballerina/io"), args={@Argument(name="value", type=TypeKind.FLOAT)}, isPublic=true)
public class WriteFloat64 {
    private static final Logger log = LoggerFactory.getLogger(WriteFloat64.class);

    public static Object writeFloat64(Strand strand, ObjectValue dataChannelObj, double value) {
        DataChannel channel = (DataChannel)dataChannelObj.getNativeData("data_channel");
        try {
            channel.writeDouble(value, Representation.BIT_64);
        }
        catch (IOException e) {
            log.error("Error occurred while writing float64.", (Throwable)e);
            return IOUtils.createError(e);
        }
        return null;
    }
}

