/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.nativeimpl;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.stdlib.io.channels.base.Channel;
import org.ballerinalang.stdlib.io.utils.IOUtils;

@BallerinaFunction(orgName="ballerina", packageName="io", functionName="close", receiver=@Receiver(type=TypeKind.OBJECT, structType="ReadableByteChannel", structPackage="ballerina/io"), returnType={@ReturnType(type=TypeKind.ERROR)}, isPublic=true)
public class CloseReadableByteChannel {
    public static Object close(Strand strand, ObjectValue channel) {
        Channel byteChannel = (Channel)channel.getNativeData("byteChannel");
        try {
            byteChannel.close();
        }
        catch (ClosedChannelException e) {
            return IOUtils.createError("channel already closed.");
        }
        catch (IOException e) {
            return IOUtils.createError(e);
        }
        return null;
    }
}

