/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.nativeimpl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BField;
import org.ballerinalang.jvm.types.BStructureType;
import org.ballerinalang.jvm.types.BTableType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BUnionType;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.jvm.values.MapValueImpl;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.TableValue;
import org.ballerinalang.jvm.values.TypedescValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.stdlib.io.channels.base.DelimitedRecordChannel;
import org.ballerinalang.stdlib.io.utils.BallerinaIOException;
import org.ballerinalang.stdlib.io.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(orgName="ballerina", packageName="io", functionName="getTable", receiver=@Receiver(type=TypeKind.OBJECT, structType="ReadableCSVChannel", structPackage="ballerina/io"), args={@Argument(name="structType", type=TypeKind.TYPEDESC)}, returnType={@ReturnType(type=TypeKind.TABLE), @ReturnType(type=TypeKind.ERROR)}, isPublic=true)
public class GetTable {
    private static final Logger log = LoggerFactory.getLogger(GetTable.class);
    private static final String CSV_CHANNEL_DELIMITED_STRUCT_FIELD = "dc";

    public static Object getTable(Strand strand, ObjectValue csvChannel, TypedescValue typedescValue) {
        try {
            ObjectValue delimitedObj = (ObjectValue)csvChannel.get(CSV_CHANNEL_DELIMITED_STRUCT_FIELD);
            DelimitedRecordChannel delimitedChannel = (DelimitedRecordChannel)delimitedObj.getNativeData("txt_record");
            if (delimitedChannel.hasReachedEnd()) {
                return IOUtils.createEoFError();
            }
            ArrayList<String[]> records = new ArrayList<String[]>();
            while (delimitedChannel.hasNext()) {
                records.add(delimitedChannel.read());
            }
            return GetTable.getTable(typedescValue, records);
        }
        catch (BallerinaException | BallerinaIOException e) {
            String msg = "failed to process the delimited file: " + e.getMessage();
            log.error(msg, e);
            return IOUtils.createError(msg);
        }
    }

    private static TableValue getTable(TypedescValue typedescValue, List records) {
        BType describingType = typedescValue.getDescribingType();
        TableValue table = new TableValue((BType)new BTableType(describingType), null, null);
        BStructureType structType = (BStructureType)describingType;
        for (Object obj : records) {
            String[] fields = (String[])obj;
            MapValueImpl<String, Object> struct = GetTable.getStruct(fields, structType);
            if (struct == null) continue;
            table.addData(struct);
        }
        return table;
    }

    private static MapValueImpl<String, Object> getStruct(String[] fields, BStructureType structType) {
        Map internalStructFields = structType.getFields();
        int fieldLength = internalStructFields.size();
        MapValueImpl struct = null;
        if (fields.length > 0) {
            Iterator itr = internalStructFields.entrySet().iterator();
            struct = new MapValueImpl((BType)structType);
            for (int i = 0; i < fieldLength; ++i) {
                BField internalStructField = (BField)itr.next().getValue();
                int type = internalStructField.getFieldType().getTag();
                String fieldName = internalStructField.getFieldName();
                if (fields.length > i) {
                    String value = fields[i];
                    switch (type) {
                        case 1: 
                        case 3: 
                        case 5: 
                        case 6: {
                            GetTable.populateRecord(type, (MapValueImpl<String, Object>)struct, fieldName, value);
                            break;
                        }
                        case 21: {
                            List members = ((BUnionType)internalStructField.getFieldType()).getMemberTypes();
                            if (((BType)members.get(0)).getTag() == 10) {
                                GetTable.populateRecord(((BType)members.get(1)).getTag(), (MapValueImpl<String, Object>)struct, fieldName, value);
                                break;
                            }
                            if (((BType)members.get(1)).getTag() == 10) {
                                GetTable.populateRecord(((BType)members.get(0)).getTag(), (MapValueImpl<String, Object>)struct, fieldName, value);
                                break;
                            }
                            throw IOUtils.createError("unsupported nillable field for value: " + value);
                        }
                        default: {
                            throw IOUtils.createError("type casting support only for int, float, boolean and string. Invalid value for the struct field: " + value);
                        }
                    }
                    continue;
                }
                struct.put((Object)fieldName, null);
            }
        }
        return struct;
    }

    private static void populateRecord(int type, MapValueImpl<String, Object> struct, String fieldName, String value) {
        switch (type) {
            case 1: {
                struct.put((Object)fieldName, value == null ? null : Long.valueOf(Long.parseLong(value)));
                return;
            }
            case 3: {
                struct.put((Object)fieldName, value == null ? null : Double.valueOf(Double.parseDouble(value)));
                break;
            }
            case 5: {
                struct.put((Object)fieldName, (Object)value);
                break;
            }
            case 6: {
                struct.put((Object)fieldName, value == null ? null : Boolean.valueOf(Boolean.parseBoolean(value)));
                break;
            }
            default: {
                throw IOUtils.createError("type casting support only for int, float, boolean and string. Invalid value for the struct field: " + value);
            }
        }
    }
}

