/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.nativeimpl;

import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.stdlib.io.channels.AbstractNativeChannel;
import org.ballerinalang.stdlib.io.channels.FileIOChannel;
import org.ballerinalang.stdlib.io.channels.base.Channel;
import org.ballerinalang.stdlib.io.utils.BallerinaIOException;
import org.ballerinalang.stdlib.io.utils.IOUtils;

@BallerinaFunction(orgName="ballerina", packageName="io", functionName="openReadableFile", args={@Argument(name="path", type=TypeKind.STRING)}, isPublic=true)
public class OpenReadableFile
extends AbstractNativeChannel {
    private static final String READ_ACCESS_MODE = "r";

    public static Object openReadableFile(Strand strand, String pathUrl) {
        Object channel;
        try {
            channel = OpenReadableFile.createChannel(OpenReadableFile.inFlow(pathUrl));
        }
        catch (BallerinaIOException e) {
            channel = IOUtils.createError(e);
        }
        catch (ErrorValue e) {
            return e;
        }
        return channel;
    }

    private static Channel inFlow(String pathUrl) throws BallerinaIOException {
        Path path = Paths.get(pathUrl, new String[0]);
        FileChannel fileChannel = IOUtils.openFileChannelExtended(path, READ_ACCESS_MODE);
        FileIOChannel channel = new FileIOChannel(fileChannel);
        channel.setReadable(true);
        return channel;
    }
}

