/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.nativeimpl;

import java.io.IOException;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.stdlib.io.channels.base.DataChannel;
import org.ballerinalang.stdlib.io.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(orgName="ballerina", packageName="io", functionName="readString", receiver=@Receiver(type=TypeKind.OBJECT, structType="ReadableDataChannel", structPackage="ballerina.io"), args={@Argument(name="nBytes", type=TypeKind.INT), @Argument(name="encoding", type=TypeKind.STRING)}, isPublic=true)
public class ReadString {
    private static final Logger log = LoggerFactory.getLogger(ReadString.class);

    public static Object readString(Strand strand, ObjectValue dataChannelObj, long nBytes, String encoding) {
        DataChannel channel = (DataChannel)dataChannelObj.getNativeData("data_channel");
        if (channel.hasReachedEnd()) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Channel %d reached it's end", channel.hashCode()));
            }
            return IOUtils.createEoFError();
        }
        try {
            return channel.readString((int)nBytes, encoding);
        }
        catch (IOException e) {
            String msg = "Error occurred while reading string: " + e.getMessage();
            log.error(msg, (Throwable)e);
            return IOUtils.createError(msg);
        }
    }
}

