/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.nativeimpl;

import java.util.IllegalFormatConversionException;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.util.exceptions.BLangExceptionHelper;
import org.ballerinalang.jvm.util.exceptions.RuntimeErrors;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.utils.StringUtils;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;

@BallerinaFunction(orgName="ballerina", packageName="io", functionName="sprintf", args={@Argument(name="format", type=TypeKind.STRING), @Argument(name="args", type=TypeKind.ARRAY)}, returnType={@ReturnType(type=TypeKind.STRING)}, isPublic=true)
public class Sprintf {
    public static String sprintf(Strand strand, String format, ArrayValue args) {
        StringBuilder result = new StringBuilder();
        int k = 0;
        for (int i = 0; i < format.length(); ++i) {
            if (format.charAt(i) == '%' && i + 1 < format.length()) {
                int j = i + 1;
                if (k >= args.size()) {
                    throw BLangExceptionHelper.getRuntimeException((RuntimeErrors)RuntimeErrors.NOT_ENOUGH_FORMAT_ARGUMENTS, (Object[])new Object[0]);
                }
                StringBuilder padding = new StringBuilder();
                while (Character.isDigit(format.charAt(j)) || format.charAt(j) == '.') {
                    padding.append(format.charAt(j));
                    ++j;
                }
                try {
                    char formatSpecifier = format.charAt(j);
                    Object ref = args.getRefValue((long)k);
                    switch (formatSpecifier) {
                        case 'B': 
                        case 'b': 
                        case 'd': 
                        case 'f': {
                            if (ref == null) {
                                throw BLangExceptionHelper.getRuntimeException((RuntimeErrors)RuntimeErrors.ILLEGAL_FORMAT_CONVERSION, (Object[])new Object[]{format.charAt(j) + " != ()"});
                            }
                            result.append(String.format("%" + padding + formatSpecifier, ref));
                            break;
                        }
                        case 'X': 
                        case 'x': {
                            if (ref == null) {
                                throw BLangExceptionHelper.getRuntimeException((RuntimeErrors)RuntimeErrors.ILLEGAL_FORMAT_CONVERSION, (Object[])new Object[]{format.charAt(j) + " != ()"});
                            }
                            Sprintf.formatHexString(args, result, k, padding, formatSpecifier);
                            break;
                        }
                        case 's': {
                            if (ref != null) {
                                result.append(String.format("%" + padding + "s", StringUtils.getStringValue((Strand)strand, (Object)ref)));
                            }
                            break;
                        }
                        case '%': {
                            result.append("%");
                            break;
                        }
                        default: {
                            throw BLangExceptionHelper.getRuntimeException((RuntimeErrors)RuntimeErrors.INVALID_FORMAT_SPECIFIER, (Object[])new Object[]{Character.valueOf(format.charAt(j))});
                        }
                    }
                }
                catch (IllegalFormatConversionException e) {
                    throw BLangExceptionHelper.getRuntimeException((RuntimeErrors)RuntimeErrors.ILLEGAL_FORMAT_CONVERSION, (Object[])new Object[]{format.charAt(j) + " != " + TypeChecker.getType((Object)args.getRefValue((long)k))});
                }
                if (format.charAt(j) == '%') {
                    ++i;
                    continue;
                }
                ++k;
                i = j;
                continue;
            }
            result.append(format.charAt(i));
        }
        return result.toString();
    }

    private static void formatHexString(ArrayValue args, StringBuilder result, int k, StringBuilder padding, char x) {
        Object argsValues = args.get((long)k);
        BType type = TypeChecker.getType((Object)argsValues);
        if (20 == type.getTag() && 2 == ((BArrayType)type).getElementType().getTag()) {
            ArrayValue byteArray = (ArrayValue)argsValues;
            for (int i = 0; i < byteArray.size(); ++i) {
                result.append(String.format("%" + padding + x, byteArray.getByte((long)i)));
            }
        } else {
            result.append(String.format("%" + padding + x, argsValues));
        }
    }
}

