/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.nativeimpl;

import java.util.IllegalFormatConversionException;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.util.exceptions.BLangExceptionHelper;
import org.ballerinalang.jvm.util.exceptions.RuntimeErrors;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.utils.StringUtils;

public class Sprintf {
    private Sprintf() {
    }

    public static String sprintf(String format, Object ... args) {
        StringBuilder result = new StringBuilder();
        int k = 0;
        for (int i = 0; i < format.length(); ++i) {
            if (format.charAt(i) == '%' && i + 1 < format.length()) {
                int j = i + 1;
                if (k >= args.length) {
                    throw BLangExceptionHelper.getRuntimeException((RuntimeErrors)RuntimeErrors.NOT_ENOUGH_FORMAT_ARGUMENTS, (Object[])new Object[0]);
                }
                StringBuilder padding = new StringBuilder();
                while (Character.isDigit(format.charAt(j)) || format.charAt(j) == '.') {
                    padding.append(format.charAt(j));
                    ++j;
                }
                try {
                    char formatSpecifier = format.charAt(j);
                    Object ref = args[k];
                    switch (formatSpecifier) {
                        case 'B': 
                        case 'b': 
                        case 'd': 
                        case 'f': {
                            if (ref == null) {
                                throw BLangExceptionHelper.getRuntimeException((RuntimeErrors)RuntimeErrors.ILLEGAL_FORMAT_CONVERSION, (Object[])new Object[]{format.charAt(j) + " != ()"});
                            }
                            result.append(String.format("%" + padding + formatSpecifier, ref));
                            break;
                        }
                        case 'X': 
                        case 'x': {
                            if (ref == null) {
                                throw BLangExceptionHelper.getRuntimeException((RuntimeErrors)RuntimeErrors.ILLEGAL_FORMAT_CONVERSION, (Object[])new Object[]{format.charAt(j) + " != ()"});
                            }
                            Sprintf.formatHexString(result, k, padding, formatSpecifier, args);
                            break;
                        }
                        case 's': {
                            if (ref != null) {
                                result.append(String.format("%" + padding + "s", StringUtils.getStringValue((Object)ref)));
                            }
                            break;
                        }
                        case '%': {
                            result.append("%");
                            break;
                        }
                        default: {
                            throw BLangExceptionHelper.getRuntimeException((RuntimeErrors)RuntimeErrors.INVALID_FORMAT_SPECIFIER, (Object[])new Object[]{Character.valueOf(format.charAt(j))});
                        }
                    }
                }
                catch (IllegalFormatConversionException e) {
                    throw BLangExceptionHelper.getRuntimeException((RuntimeErrors)RuntimeErrors.ILLEGAL_FORMAT_CONVERSION, (Object[])new Object[]{format.charAt(j) + " != " + TypeChecker.getType((Object)args[k])});
                }
                if (format.charAt(j) == '%') {
                    ++i;
                    continue;
                }
                ++k;
                i = j;
                continue;
            }
            result.append(format.charAt(i));
        }
        return result.toString();
    }

    private static void formatHexString(StringBuilder result, int k, StringBuilder padding, char x, Object ... args) {
        Object argsValues = args[k];
        BType type = TypeChecker.getType((Object)argsValues);
        if (20 == type.getTag() && 2 == ((BArrayType)type).getElementType().getTag()) {
            ArrayValue byteArray = (ArrayValue)argsValues;
            for (int i = 0; i < byteArray.size(); ++i) {
                result.append(String.format("%" + padding + x, byteArray.getByte((long)i)));
            }
        } else {
            result.append(String.format("%" + padding + x, argsValues));
        }
    }
}

