/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.nativeimpl;

import java.io.IOException;
import java.io.Reader;
import java.nio.channels.ClosedChannelException;
import org.ballerinalang.jvm.JSONParser;
import org.ballerinalang.jvm.StringUtils;
import org.ballerinalang.jvm.XMLFactory;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.XMLValue;
import org.ballerinalang.stdlib.io.channels.base.Channel;
import org.ballerinalang.stdlib.io.channels.base.CharacterChannel;
import org.ballerinalang.stdlib.io.readers.CharacterChannelReader;
import org.ballerinalang.stdlib.io.utils.BallerinaIOException;
import org.ballerinalang.stdlib.io.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CharacterChannelUtils {
    private static final Logger log = LoggerFactory.getLogger(CharacterChannelUtils.class);

    private CharacterChannelUtils() {
    }

    public static void initCharacterChannel(ObjectValue characterChannel, ObjectValue byteChannelInfo, String encoding) {
        try {
            Channel byteChannel = (Channel)byteChannelInfo.getNativeData("byteChannel");
            CharacterChannel bCharacterChannel = new CharacterChannel(byteChannel, encoding);
            characterChannel.addNativeData("char_channel", (Object)bCharacterChannel);
        }
        catch (Exception e) {
            String message = "error occurred while converting byte channel to character channel: " + e.getMessage();
            log.error(message, (Throwable)e);
            throw IOUtils.createError(message);
        }
    }

    public static Object read(ObjectValue channel, long numberOfCharacters) {
        CharacterChannel characterChannel = (CharacterChannel)channel.getNativeData("char_channel");
        if (characterChannel.hasReachedEnd()) {
            return IOUtils.createEoFError();
        }
        try {
            return characterChannel.read((int)numberOfCharacters);
        }
        catch (BallerinaIOException e) {
            log.error("error occurred while reading characters.", (Throwable)e);
            return IOUtils.createError(e);
        }
    }

    public static Object readJson(ObjectValue channel) {
        CharacterChannel charChannel = (CharacterChannel)channel.getNativeData("char_channel");
        CharacterChannelReader reader = new CharacterChannelReader(charChannel);
        try {
            Object returnValue = JSONParser.parse((Reader)reader);
            if (returnValue instanceof String) {
                return StringUtils.fromString((String)((String)returnValue));
            }
            return returnValue;
        }
        catch (BallerinaException e) {
            log.error("unable to read json from character channel", (Throwable)e);
            return IOUtils.createError(e);
        }
    }

    public static Object readXml(ObjectValue channel) {
        CharacterChannel charChannel = (CharacterChannel)channel.getNativeData("char_channel");
        CharacterChannelReader reader = new CharacterChannelReader(charChannel);
        try {
            return XMLFactory.parse((Reader)reader);
        }
        catch (BallerinaException e) {
            return IOUtils.createError(e);
        }
    }

    public static Object close(ObjectValue channel) {
        CharacterChannel charChannel = (CharacterChannel)channel.getNativeData("char_channel");
        try {
            charChannel.close();
        }
        catch (ClosedChannelException e) {
            return IOUtils.createError("channel already closed.");
        }
        catch (IOException e) {
            return IOUtils.createError(e);
        }
        return null;
    }

    public static Object write(ObjectValue channel, String content, long startOffset) {
        CharacterChannel characterChannel = (CharacterChannel)channel.getNativeData("char_channel");
        try {
            return characterChannel.write(content, (int)startOffset);
        }
        catch (IOException e) {
            return IOUtils.createError(e);
        }
    }

    public static Object writeJson(ObjectValue characterChannelObj, Object content) {
        try {
            CharacterChannel characterChannel = (CharacterChannel)characterChannelObj.getNativeData("char_channel");
            IOUtils.writeFull(characterChannel, org.ballerinalang.jvm.values.utils.StringUtils.getJsonString((Object)content));
        }
        catch (BallerinaIOException e) {
            return IOUtils.createError(e);
        }
        return null;
    }

    public static Object writeXml(ObjectValue characterChannelObj, XMLValue<?> content) {
        try {
            CharacterChannel characterChannel = (CharacterChannel)characterChannelObj.getNativeData("char_channel");
            IOUtils.writeFull(characterChannel, content.toString());
        }
        catch (BallerinaIOException e) {
            return IOUtils.createError(e);
        }
        return null;
    }
}

