/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.channels.base;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import org.ballerinalang.stdlib.io.channels.base.IOChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Channel
implements IOChannel {
    private ByteChannel byteChannel;
    private boolean hasReachedToEnd = false;
    private boolean readable;
    private static final Logger log = LoggerFactory.getLogger(Channel.class);

    public Channel(ByteChannel byteChannel) {
        this.byteChannel = byteChannel;
    }

    public abstract void transfer(int var1, int var2, WritableByteChannel var3) throws IOException;

    @Override
    public int id() {
        return this.byteChannel.hashCode();
    }

    @Override
    public boolean hasReachedEnd() {
        return this.hasReachedToEnd;
    }

    public ByteChannel getByteChannel() {
        return this.byteChannel;
    }

    public int read(ByteBuffer buffer) throws IOException {
        int readBytes = this.byteChannel.read(buffer);
        if (readBytes < 0) {
            readBytes = 0;
            this.hasReachedToEnd = true;
        }
        return readBytes;
    }

    public int write(ByteBuffer content) throws IOException {
        return this.byteChannel.write(content);
    }

    public InputStream getInputStream() throws IOException {
        if (!this.byteChannel.isOpen()) {
            String message = "Channel is already closed.";
            throw new IOException(message);
        }
        return Channels.newInputStream(this.byteChannel);
    }

    public void setReadable(boolean readable) {
        this.readable = readable;
    }

    public boolean isReadable() {
        return this.readable;
    }

    @Override
    public void close() throws IOException {
        if (null != this.byteChannel) {
            this.byteChannel.close();
        } else {
            log.error("The channel has already being closed");
        }
    }
}

