/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.jdbc.methods;

import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinax.jdbc.Constants;
import org.ballerinax.jdbc.datasource.PoolKey;
import org.ballerinax.jdbc.datasource.PoolOptionsWrapper;
import org.ballerinax.jdbc.datasource.SQLDatasource;
import org.ballerinax.jdbc.datasource.SQLDatasourceUtils;
import org.ballerinax.jdbc.exceptions.ErrorGenerator;

public class ExternFunctions {
    private ExternFunctions() {
    }

    public static Object close(ObjectValue client) {
        SQLDatasource datasource = (SQLDatasource)client.getNativeData("Client");
        if (datasource != null && !datasource.isGlobalDatasource()) {
            datasource.decrementClientCounterAndAttemptPoolShutdown();
        }
        return null;
    }

    public static void createClient(ObjectValue client, MapValue<String, Object> config, MapValue<String, Object> globalPoolOptions) {
        boolean userProvidedPoolOptionsNotPresent;
        String url = config.getStringValue("url");
        if (!ExternFunctions.isJdbcUrlValid(url)) {
            throw ErrorGenerator.getSQLApplicationError("invalid JDBC URL: " + url);
        }
        String username = config.getStringValue("username");
        String password = config.getStringValue("password");
        MapValue dbOptions = config.getMapValue("dbOptions");
        MapValue<String, Object> poolOptions = config.getMapValue("poolOptions");
        boolean bl = userProvidedPoolOptionsNotPresent = poolOptions == null;
        if (userProvidedPoolOptionsNotPresent) {
            poolOptions = globalPoolOptions;
        }
        PoolOptionsWrapper poolOptionsWrapper = new PoolOptionsWrapper(poolOptions, new PoolKey(url, dbOptions));
        String dbType = url.split(":")[1].toUpperCase(Locale.getDefault());
        SQLDatasource.SQLDatasourceParamsBuilder builder = new SQLDatasource.SQLDatasourceParamsBuilder(dbType);
        SQLDatasource.SQLDatasourceParams sqlDatasourceParams = builder.withPoolOptions(poolOptionsWrapper).withJdbcUrl(url).withUsername(username).withPassword(password).withDbOptionsMap((MapValue<String, Object>)dbOptions).withIsGlobalDatasource(userProvidedPoolOptionsNotPresent).build();
        SQLDatasource sqlDatasource = sqlDatasourceParams.getPoolOptionsWrapper().retrieveDatasource(sqlDatasourceParams);
        client.addNativeData("Client", (Object)sqlDatasource);
        client.addNativeData(Constants.CONNECTOR_ID_KEY, (Object)UUID.randomUUID().toString());
    }

    private static boolean isJdbcUrlValid(String jdbcUrl) {
        boolean isJdbcUrlEmpty = jdbcUrl.isEmpty();
        String[] splitComponents = jdbcUrl.split(":");
        return !isJdbcUrlEmpty && splitComponents.length > 2 && "jdbc".equals(splitComponents[0].toLowerCase(Locale.getDefault()));
    }

    public static void initGlobalPoolContainer(ObjectValue globalPoolConfigContainer, MapValue<String, Object> poolConfig) {
        SQLDatasourceUtils.addDatasourceContainer(poolConfig, new ConcurrentHashMap<PoolKey, SQLDatasource>());
    }
}

